/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.validation;

import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.xml.transform.ResourceSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class SchemaLoaderUtils {
    public static Schema loadSchema(Resource resource, String schemaLanguage) throws IOException, SAXException {
        return SchemaLoaderUtils.loadSchema(new Resource[]{resource}, schemaLanguage);
    }

    public static Schema loadSchema(Resource[] resources, String schemaLanguage) throws IOException, SAXException {
        Assert.notEmpty((Object[])resources, (String)"No resources given");
        Assert.hasLength((String)schemaLanguage, (String)"No schema language provided");
        Source[] schemaSources = new Source[resources.length];
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        for (int i = 0; i < resources.length; ++i) {
            Assert.notNull((Object)resources[i], (String)"Resource is null");
            Assert.isTrue((boolean)resources[i].exists(), (String)("Resource " + resources[i] + " does not exist"));
            schemaSources[i] = new ResourceSource(xmlReader, resources[i]);
        }
        SchemaFactory schemaFactory = SchemaFactory.newInstance(schemaLanguage);
        return schemaFactory.newSchema(schemaSources);
    }

    public static String getSystemId(Resource resource) {
        try {
            return resource.getURL().toString();
        }
        catch (IOException e) {
            return null;
        }
    }
}

