/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.axiom;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.springframework.ws.soap.SoapHeader;
import org.springframework.ws.soap.SoapHeaderElement;
import org.springframework.ws.soap.SoapHeaderException;
import org.springframework.ws.soap.axiom.AxiomResult;
import org.springframework.ws.soap.axiom.AxiomSoapElement;
import org.springframework.ws.soap.axiom.AxiomSoapHeaderElement;
import org.springframework.ws.soap.axiom.AxiomSoapHeaderException;
import org.springframework.xml.namespace.QNameUtils;

abstract class AxiomSoapHeader
extends AxiomSoapElement
implements SoapHeader {
    AxiomSoapHeader(SOAPHeader axiomHeader, SOAPFactory axiomFactory) {
        super((OMElement)axiomHeader, axiomFactory);
    }

    public Result getResult() {
        return new AxiomResult((OMContainer)this.getAxiomHeader(), (OMFactory)this.getAxiomFactory());
    }

    public SoapHeaderElement addHeaderElement(QName name) {
        try {
            OMNamespace namespace = this.getAxiomFactory().createOMNamespace(name.getNamespaceURI(), QNameUtils.getPrefix(name));
            SOAPHeaderBlock axiomHeaderBlock = this.getAxiomHeader().addHeaderBlock(name.getLocalPart(), namespace);
            return new AxiomSoapHeaderElement(axiomHeaderBlock, this.getAxiomFactory());
        }
        catch (OMException ex) {
            throw new AxiomSoapHeaderException(ex);
        }
    }

    public void removeHeaderElement(QName name) throws SoapHeaderException {
        try {
            OMElement element = this.getAxiomHeader().getFirstChildWithName(name);
            if (element != null) {
                element.detach();
            }
        }
        catch (OMException ex) {
            throw new AxiomSoapHeaderException(ex);
        }
    }

    public Iterator examineMustUnderstandHeaderElements(String role) {
        try {
            return new AxiomSoapHeaderElementIterator(this.getAxiomHeader().examineMustUnderstandHeaderBlocks(role));
        }
        catch (OMException ex) {
            throw new AxiomSoapHeaderException(ex);
        }
    }

    public Iterator examineAllHeaderElements() {
        try {
            return new AxiomSoapHeaderElementIterator(this.getAxiomHeader().examineAllHeaderBlocks());
        }
        catch (OMException ex) {
            throw new AxiomSoapHeaderException(ex);
        }
    }

    public Iterator examineHeaderElements(QName name) throws SoapHeaderException {
        try {
            return new AxiomSoapHeaderElementIterator(this.getAxiomHeader().getChildrenWithName(name));
        }
        catch (OMException ex) {
            throw new AxiomSoapHeaderException(ex);
        }
    }

    protected SOAPHeader getAxiomHeader() {
        return (SOAPHeader)this.getAxiomElement();
    }

    protected class AxiomSoapHeaderElementIterator
    implements Iterator {
        private final Iterator axiomIterator;

        protected AxiomSoapHeaderElementIterator(Iterator axiomIterator) {
            this.axiomIterator = axiomIterator;
        }

        public boolean hasNext() {
            return this.axiomIterator.hasNext();
        }

        public Object next() {
            try {
                SOAPHeaderBlock axiomHeaderBlock = (SOAPHeaderBlock)this.axiomIterator.next();
                return new AxiomSoapHeaderElement(axiomHeaderBlock, AxiomSoapHeader.this.getAxiomFactory());
            }
            catch (OMException ex) {
                throw new AxiomSoapHeaderException(ex);
            }
        }

        public void remove() {
            this.axiomIterator.remove();
        }
    }
}

