/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.wsdl.wsdl11.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Output;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.ws.wsdl.wsdl11.provider.PortTypesProvider;

public abstract class AbstractPortTypesProvider
implements PortTypesProvider {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String portTypeName;

    public String getPortTypeName() {
        return this.portTypeName;
    }

    public void setPortTypeName(String portTypeName) {
        this.portTypeName = portTypeName;
    }

    public void addPortTypes(Definition definition) throws WSDLException {
        Assert.notNull((Object)this.getPortTypeName(), (String)"'portTypeName' is required");
        PortType portType = definition.createPortType();
        this.populatePortType(definition, portType);
        this.createOperations(definition, portType);
        portType.setUndefined(false);
        definition.addPortType(portType);
    }

    protected void populatePortType(Definition definition, PortType portType) throws WSDLException {
        QName portTypeName = new QName(definition.getTargetNamespace(), this.getPortTypeName());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating port type [" + portTypeName + "]"));
        }
        portType.setQName(portTypeName);
    }

    private void createOperations(Definition definition, PortType portType) throws WSDLException {
        List messages;
        HashMap<String, ArrayList<Message>> operations = new HashMap<String, ArrayList<Message>>();
        Iterator<Object> iterator = definition.getMessages().values().iterator();
        while (iterator.hasNext()) {
            Message message = (Message)iterator.next();
            String operationName = this.getOperationName(message);
            if (!StringUtils.hasText((String)operationName)) continue;
            messages = (ArrayList<Message>)operations.get(operationName);
            if (messages == null) {
                messages = new ArrayList<Message>();
                operations.put(operationName, (ArrayList<Message>)messages);
            }
            messages.add(message);
        }
        if (operations.isEmpty() && this.logger.isWarnEnabled()) {
            this.logger.warn((Object)"No operations were created, make sure the WSDL contains messages");
        }
        iterator = operations.keySet().iterator();
        while (iterator.hasNext()) {
            String operationName = (String)iterator.next();
            Operation operation = definition.createOperation();
            operation.setName(operationName);
            messages = (List)operations.get(operationName);
            Iterator messagesIterator = messages.iterator();
            while (messagesIterator.hasNext()) {
                Message message = (Message)messagesIterator.next();
                if (this.isInputMessage(message)) {
                    Input input = definition.createInput();
                    input.setMessage(message);
                    this.populateInput(definition, input);
                    operation.setInput(input);
                    continue;
                }
                if (this.isOutputMessage(message)) {
                    Output output = definition.createOutput();
                    output.setMessage(message);
                    this.populateOutput(definition, output);
                    operation.setOutput(output);
                    continue;
                }
                if (!this.isFaultMessage(message)) continue;
                Fault fault = definition.createFault();
                fault.setMessage(message);
                this.populateFault(definition, fault);
                operation.addFault(fault);
            }
            operation.setStyle(this.getOperationType(operation));
            operation.setUndefined(false);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Adding operation [" + operation.getName() + "] to port type [" + portType.getQName() + "]"));
            }
            portType.addOperation(operation);
        }
    }

    protected abstract String getOperationName(Message var1);

    protected abstract boolean isInputMessage(Message var1);

    protected void populateInput(Definition definition, Input input) {
        input.setName(input.getMessage().getQName().getLocalPart());
    }

    protected abstract boolean isOutputMessage(Message var1);

    protected void populateOutput(Definition definition, Output output) {
        output.setName(output.getMessage().getQName().getLocalPart());
    }

    protected abstract boolean isFaultMessage(Message var1);

    protected void populateFault(Definition definition, Fault fault) {
        fault.setName(fault.getMessage().getQName().getLocalPart());
    }

    protected OperationType getOperationType(Operation operation) {
        if (operation.getInput() != null && operation.getOutput() != null) {
            return OperationType.REQUEST_RESPONSE;
        }
        if (operation.getInput() != null && operation.getOutput() == null) {
            return OperationType.ONE_WAY;
        }
        if (operation.getInput() == null && operation.getOutput() != null) {
            return OperationType.NOTIFICATION;
        }
        return null;
    }
}

