/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.addressing.server;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.BeansException;
import org.springframework.ws.soap.addressing.server.AbstractActionEndpointMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleActionEndpointMapping
extends AbstractActionEndpointMapping {
    private final Map<URI, Object> actionMap = new HashMap<URI, Object>();
    private URI address;

    public void setMappings(Properties mappings) throws URISyntaxException {
        this.setActionMap(mappings);
    }

    public void setActionMap(Map<?, Object> actionMap) throws URISyntaxException {
        for (Map.Entry<?, Object> entry : actionMap.entrySet()) {
            URI action;
            if (entry.getKey() instanceof String) {
                action = new URI((String)entry.getKey());
            } else if (entry.getKey() instanceof URI) {
                action = (URI)entry.getKey();
            } else {
                throw new IllegalArgumentException("Invalid key [" + entry.getKey() + "]; expected String or URI");
            }
            this.actionMap.put(action, entry.getValue());
        }
    }

    public void setAddress(URI address) {
        this.address = address;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        this.registerEndpoints(this.actionMap);
    }

    protected void registerEndpoints(Map<URI, Object> actionMap) throws BeansException {
        if (actionMap.isEmpty()) {
            this.logger.warn((Object)"Neither 'actionMap' nor 'mappings' set on SimpleActionEndpointMapping");
        } else {
            for (Map.Entry<URI, Object> entry : actionMap.entrySet()) {
                URI action = entry.getKey();
                Object endpoint = entry.getValue();
                if (endpoint instanceof String) {
                    endpoint = ((String)endpoint).trim();
                }
                this.registerEndpoint(action, endpoint);
            }
        }
    }

    @Override
    protected URI getEndpointAddress(Object endpoint) {
        return this.address;
    }
}

