package mx.com.amx.mx.dda.ws.dto;

import java.io.Serializable;

/**
 * Representa el item referente al detalle de amortizacion del Titulos y que seran parte de la respuesta del proceso de calculo de Amortizacion Mensual
 * * Los campos que usa son:
 * <br>
 * fechaMes: Representa un fecha de los distintos meses comprendidos en el rango de vida del titulo.
 * monto : Es el valor de la amortizacion correspondiente a la fecha y que se determina segun distintos calculos y reglas.
 *
 */

public class ItDetalleAmortizaDTO implements Serializable 
{
	private static final long serialVersionUID = 1L;
	private String fechaMes;
	private String monto;
	
	public String getFechaMes() {
		return fechaMes;
	}
	public void setFechaMes(String fechaMes) {
		this.fechaMes = fechaMes;
	}
	public String getMonto() {
		return monto;
	}
	public void setMonto(String monto) {
		this.monto = monto;
	}
	
	public String toString() 
	{
		StringBuilder result = new StringBuilder();
		String NEW_LINE = System.getProperty("line.separator");
		result.append(" [Begin of Class] " + NEW_LINE);
		result.append(this.getClass().getSimpleName() + " Object {" + NEW_LINE);
		result.append(" fechaMes: _" + this.getFechaMes() + "_" + NEW_LINE);
		result.append(" monto: _" + this.getMonto() + "_" + NEW_LINE);
		result.append(" [End of Class] " + NEW_LINE);
		result.append("}");
		NEW_LINE = null;

		return result.toString();
	}

}
