package mx.com.amx.mx.dda.ws.dto;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * Representa el item referente a los Titulos mismos que estan relacionados a un contrato y seran parte de la respuesta del proceso de calculo de Amortizacion Mensual
 * * Los campos que usa son:
 * <br>
 * ID_TITULO_CNTORIG: Es el id del Titulo (Original).
 * lobDetalle : Es un objeto de items Detalle asociados al Titulo. Aqui se enlistan por mes los montos segun calculos para la amortizacion de dicho titulo.
 *
 */

public class ItTituloDTO implements Serializable 
{
	private static final long serialVersionUID = 1L;
	private String ID_TITULO_CNTORIG;
	private List<ItDetalleAmortizaDTO> lobDetalle;
	
	
	public ItTituloDTO()
	{
		inicializaAtributos();
	}
	
	public String getID_TITULO_CNTORIG() {
		return ID_TITULO_CNTORIG;
	}
	public void setID_TITULO_CNTORIG(String iD_TITULO_CNTORIG) {
		ID_TITULO_CNTORIG = iD_TITULO_CNTORIG;
	}
	public List<ItDetalleAmortizaDTO> getLobDetalle() {
		return lobDetalle;
	}
	public void setLobDetalle(List<ItDetalleAmortizaDTO> lobDetalle) {
		this.lobDetalle = lobDetalle;
	}
	
	public String toString() 
	{
		StringBuilder result = new StringBuilder();
		String NEW_LINE = System.getProperty("line.separator");
		result.append(" [Begin of Class] " + NEW_LINE);
		result.append(this.getClass().getSimpleName() + " Object {" + NEW_LINE);
		result.append(" ID_TITULO_CNTORIG: _" + this.getID_TITULO_CNTORIG() + "_" + NEW_LINE);
		result.append(" lobDetalle: _" + this.getLobDetalle().size() + "_" + NEW_LINE);
		result.append(" [End of Class] " + NEW_LINE);
		result.append("}");
		NEW_LINE = null;

		return result.toString();
	}
	
	
	//------  Metodos propios de la clase ---
	public void agregarItDetalleAmortizacion(ItDetalleAmortizaDTO dto)
	{
		this.lobDetalle.add(dto);
	}
	
	public void inicializaAtributos()
	{
		this.lobDetalle = new ArrayList<ItDetalleAmortizaDTO>();
	}
}
