package mx.com.amx.mx.dda.ws.dto;

import java.io.Serializable;
import java.util.List;

/**
 * Representa los parametros necesarios para obtener el promedio de Suscriptores 
 *  
 */
public class ParamObtenerSuscriptoresDTO implements Serializable 
{
	private static final long serialVersionUID = 1L;
	private List<QryEmpresasContratoDTO> empresas;
	private String fechaMes;
	
	public List<QryEmpresasContratoDTO> getEmpresas() {
		return empresas;
	}
	public void setEmpresas(List<QryEmpresasContratoDTO> empresas) {
		this.empresas = empresas;
	}
	public String getFechaMes() {
		return fechaMes;
	}
	public void setFechaMes(String fechaMes) {
		this.fechaMes = fechaMes;
	}
	
	public String toString() 
	{
		StringBuilder result = new StringBuilder();
		String NEW_LINE = System.getProperty("line.separator");
		result.append(" [Begin of Class] " + NEW_LINE);
		result.append(this.getClass().getSimpleName() + " Object {" + NEW_LINE);
		result.append(" empresas: _" + this.empresas.size() + "_" + NEW_LINE);
		result.append(" fechaMes: _" + this.getFechaMes() + "_" + NEW_LINE);
		result.append(" [End of Class] " + NEW_LINE);
		result.append("}");
		NEW_LINE = null;

		return result.toString();
	}
	
	public String listEmpresas()
	{
		String lstResultado = "";
		int lnuTotalEmpresas = this.getEmpresas().size();
		
		if(lnuTotalEmpresas > 0)
		{
			for(int xEmpresa=0; xEmpresa < lnuTotalEmpresas; xEmpresa++)
			{
				QryEmpresasContratoDTO registro = (QryEmpresasContratoDTO) this.getEmpresas().get(xEmpresa);
				if(xEmpresa == (lnuTotalEmpresas - 1))
					lstResultado = lstResultado + registro.getID_EMPRESA();
				else
					lstResultado = lstResultado + registro.getID_EMPRESA() + ",";
			}//Ends for(int xEmpresa=0; xEmpresa < lnuTotalEmpresas; xEmpresa++)
				
		}//Ends if(lnuTotalEmpresas > 0)
		return lstResultado;
	}
}
