package mx.com.amx.mx.dda.ws.dto;

import java.io.Serializable;
import java.util.List;

/**
 * Representa los parametros necesarios para obtener los titulos asociados a un contrato con base en una lista y fecha 
 * 
 * idContrato: Representa el id del contrato sobre el que se buscan los Titulos Asociados
 * idLista: Representa la lista de titulos que esta asociada el contrato y que a su vez determina los Titulos a buscar
 * fechaMes: Representa la fecha del mes en que se realiza el calculo del costo. Ej. Para marzo 2015 es 01/03/2015, ene2017: 01/01/2017,etc
 * origen: Determina el origen de datos sobre el cual se tiene que revisar, es decir la tabla de busqueda. Valores: REAL/ESPEJO
 *  
 *  fechaInicio: Es la fecha de inicio del periodo de busqueda proporcionada en el proceso de Amortizacion en formato dd/mm/yyyy
 *  fechaFin: Es la fecha de fin del periodo de busqueda proporcionada en el proceso de Amortizacion en formato dd/mm/yyyy.
 *  modulo: Indica el modulo que usara el servicio y con base en ello se aplican algunos filtros en la seleccion de titulos. Valores: AMORTIZACION, PRESUPUESTO.
 */
public class ParamObtenerTitulosDTO implements Serializable 
{
	private static final long serialVersionUID = 1L;
	private String idContrato;
	private String idLista;
	private String fechaMes;
	private String origen;
	
	//--Campos adicionales amortizacion
	private String fechaInicio;
	private String fechaFin;
	private String modulo;
	private List<ContratoTituloDTO> lobTitulos;
	
	public String getIdContrato() {
		return idContrato;
	}

	public void setIdContrato(String idContrato) {
		this.idContrato = idContrato;
	}

	public String getIdLista() {
		return idLista;
	}

	public void setIdLista(String idLista) {
		this.idLista = idLista;
	}

	public String getFechaMes() {
		return fechaMes;
	}

	public void setFechaMes(String fechaMes) {
		this.fechaMes = fechaMes;
	}

	public String getOrigen() {
		return origen;
	}

	public void setOrigen(String origen) {
		this.origen = origen;
	}

	public String getFechaInicio() {
		return fechaInicio;
	}

	public void setFechaInicio(String fechaInicio) {
		this.fechaInicio = fechaInicio;
	}

	public String getFechaFin() {
		return fechaFin;
	}

	public void setFechaFin(String fechaFin) {
		this.fechaFin = fechaFin;
	}

	public String getModulo() {
		return modulo;
	}

	public void setModulo(String modulo) {
		this.modulo = modulo;
	}

	public List<ContratoTituloDTO> getLobTitulos() {
		return lobTitulos;
	}

	public void setLobTitulos(List<ContratoTituloDTO> lobTitulos) {
		this.lobTitulos = lobTitulos;
	}

	public String toString() 
	{
		StringBuilder result = new StringBuilder();
		String NEW_LINE = System.getProperty("line.separator");
		result.append(" [Begin of Class] " + NEW_LINE);
		result.append(this.getClass().getSimpleName() + " Object {" + NEW_LINE);
		result.append(" idContrato: _" + this.getIdContrato() + "_" + NEW_LINE);
		result.append(" idLista: _" + this.getIdLista() + "_" + NEW_LINE);
		result.append(" fechaMes: _" + this.getFechaMes() + "_" + NEW_LINE);
		result.append(" origen: _" + this.getOrigen() + "_" + NEW_LINE);
		result.append(" fechaInicio: _" + this.getFechaInicio() + "_" + NEW_LINE);
		result.append(" fechaFin: _" + this.getFechaFin() + "_" + NEW_LINE);
		result.append(" modulo: _" + this.getModulo() + "_" + NEW_LINE);
		result.append(" lobTitulos: _" + this.getLobTitulos().size() + "_" + NEW_LINE);
		result.append(" [End of Class] " + NEW_LINE);
		result.append("}");
		NEW_LINE = null;

		return result.toString();
	}
}
