package mx.com.amx.mx.dda.ws.dto;

import java.io.Serializable;

/**
 * Representa la respuesta que sera enviada al Front-End por parte de este componente al ejecutar el proceso de Obtener valor de annio vigente
 * Incluye un mensaje, el annio vigente y resultado.
 *
 */
public class ResponseAnnioVigenteDTO implements Serializable 
{
	private static final long serialVersionUID = 1L;
	private String mensaje;
	private String annio;
	private boolean resultado;
	
	public String getMensaje() {
		return this.mensaje;
	}
	public void setMensaje(String mensaje) {
		this.mensaje = mensaje;
	}
	public String getAnnio() {
		return annio;
	}
	public void setAnnio(String annio) {
		this.annio = annio;
	}
	public boolean isResultado() {
		return resultado;
	}
	public void setResultado(boolean resultado) {
		this.resultado = resultado;
	}
	
	public String toString() 
	{
		StringBuilder result = new StringBuilder();
		String NEW_LINE = System.getProperty("line.separator");
		result.append(" [Begin of Class] " + NEW_LINE);
		result.append(this.getClass().getSimpleName() + " Object {" + NEW_LINE);
		result.append(" mensaje: _" + this.getMensaje() + "_" + NEW_LINE);
		result.append(" resultado: _" + this.isResultado() + "_" + NEW_LINE);
		result.append(" annio: _" + this.getAnnio() + "_" + NEW_LINE);
		result.append(" [End of Class] " + NEW_LINE);
		result.append("}");
		NEW_LINE = null;

		return result.toString();
	}
	
}
