package amx.ccie.etl.util;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Conexion {

    private final Logger log = LogManager.getLogger(this.getClass());
    private final String esq_amx  = "AMX_"+ConstantsArc.getAmxProject()+".";
    private final String pkg_pref = "PKG_"+ConstantsArc.getAmxProject()+"_";
    
    private DataSource dsOracle;
    
   
    public Connection getConnection() {

        try {
            try{
                InitialContext ctx = new InitialContext();   
                dsOracle = (DataSource)ctx.lookup("jdbc/amx_"+ConstantsArc.getAmxProject().toLowerCase());
            }catch(NamingException n){
                log.error("catch NamingException. No se pudo encontró el nombre del DataSoruce");
            }
            
            if (dsOracle == null) {
                throw new SQLException("No se encontro DataSource");
            }
            
            Connection conn = dsOracle.getConnection();
            if (conn == null) {
                throw new SQLException("No se pudo establecer una conexion");
            }
            return conn;

        } catch (SQLException e) {
            log.error("Error al conectar por medio del jdbc/amx_"+ConstantsArc.getAmxProject().toLowerCase(),e);
            return null;
        }
    }

    public void closeResources(Connection conn, Statement stmt, ResultSet rs) {
        if(rs != null){
            try {
                rs.close();
            } catch (SQLException er) {
                log.error(er.getMessage());
            }
        }
        if(stmt != null){
            try {
                stmt.close();
            } catch (SQLException es) {
                log.error(es.getMessage());
            }
        }
        if(conn != null){
            try {
                conn.close();
            } catch (SQLException ec) {
                log.error(ec.getMessage());
            }
        }
    }

    public void rollback(Connection conn) {
        try {
            conn.rollback();
        } catch (SQLException es) {
            log.error(es.getMessage());
        }
    }

    public String getEsq_amx() {
        return esq_amx;
    }

	public String getPkg_pref() {
		return pkg_pref;
	}
    
}