package amx.ccie.dto;

import java.io.InputStream;
import java.util.List;
import java.util.ResourceBundle;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import lombok.Data;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/**
 * Clase que contiene las propiedades del correo y configuracion del mismo
 * @author Jose Francisco Montiel Jimenez
 */
@Data
public class CorreosDTO {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final String NOMBRE_PORTAL = ResourceBundle.getBundle("RecursosSistema").getString("NOM_PORT");
    private String FROM = "repoven@www.rsvamx.com";
    private String PASSWORD_EMAIL = "";
    private String FROMNAME = "Portal "+NOMBRE_PORTAL;
    private InputStream FILE_SEND;
    private String[] TO = new String[]{"NA"};
    private String[] CC = new String[]{"NA"};
    private String[] CCO = new String[]{"NA"};
    private String SUBJECT;
    private String BODY;
    private String SMTP_USERNAME = "adminsecret";
    private String SMTP_PASSWORD = "";
    private String CONFIGSET = "ConfigSet";
    private String HOST;
    private int PORT = Integer.parseInt(ResourceBundle.getBundle("RecursosSistema").getString("JAVAMAIL_PORT"));
    private List<AnexoDTO> ATTACHMENTS = null;
    private boolean SEND_IMAGE_INLINE = false;
               
    /***
     * Constructor que instancia la variable Host
     */
    public CorreosDTO(){
        try {       
            InitialContext ctx = new InitialContext();
            this.HOST = (String) ctx.lookup("string/confhostmail");
        } catch (NamingException ex) {
            log.error("La variable string/confhostmail no se pudo obtener." + ex);
        }
    }
    
    protected String reemplazaCaracteres(String cadena){
        return cadena.replaceAll("á", "&#225;")
                     .replaceAll("é", "&#233;")
                     .replaceAll("í", "&#237;")
                     .replaceAll("ó", "&#243;")
                     .replaceAll("ú", "&#250;")
                     .replaceAll("Á", "&#193;")
                     .replaceAll("É", "&#201;")
                     .replaceAll("Í", "&#205;")
                     .replaceAll("Ó", "&#211;")
                     .replaceAll("Ú", "&#218;")
                     .replaceAll("ü", "&#252;")
                     .replaceAll("Ü", "&#220;")
                     .replaceAll("ñ", "&#241;")
                     .replaceAll("Ñ", "&#209;");
    }


}//end class
