package amx.ccie.etl.scheduler;

import amx.ccie.etl.dao.BitacoraDAO;
import amx.ccie.etl.dao.CatalogosDAO;
import amx.ccie.etl.dao.CorreosDAO;
import amx.ccie.etl.httpClient.TestApisEmpleado;
import amx.ccie.etl.httpClient.TestApisReporte;
import amx.ccie.etl.util.BitacoraDTO;
import java.net.MalformedURLException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.Schedule;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/**
 *
 * @author montielj
 */
@Singleton
@Startup
public class CatalogoScheduler {
    
    private final Logger log = LogManager.getLogger(this.getClass());
    
    @Schedule(hour = "13", minute = "10", second = "0", persistent = false)
    public void consultarCatalogoServicio() {
        try {
            List<BitacoraDTO> bitacora = new BitacoraDAO().getBitacora();
            bitacora.stream().forEach(cat -> log.info("Catalogo a ejecutar: {}", cat.getDescripcion()));
            log.info("Se inserta en catalogo CCI_CAT_CANAL_ATENCION");
            new CatalogosDAO().crearCanalAtencion(1);
            log.info("Inserta en catalogo CCI_CAT_CANAL_ATENCION exitoso.");
            log.info("Se ejecuta servicio de empleado.");
            new TestApisEmpleado().getEmpleado();
            log.info("Se ejecuta servicio de reporte.");
            new  TestApisReporte().getReporte();
            log.info("Servicios ejecutados correctamente.");
            new CorreosDAO().enviaCorreoReporteActivaciones("Prueba de correo");
        } catch (MalformedURLException ex) {
            log.error("Exception: {}", ex.getMessage());
        } catch (KeyManagementException | NoSuchAlgorithmException ex) {
            log.error("Exception: {}", ex.getMessage());
        } catch (Exception ex) {
            log.error("Exception: {}", ex.getMessage());
        }
    }
    
}
