package amx.ccie.etl.httpClient;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ResourceBundle;
import java.util.Scanner;

/**
 *
 * @author David Coronilla
 */
public class TestApisEmpleado {
    private final String URL = "https://reqres.in/api/users";
    
    public TestApisEmpleado(){}
    
    public void getEmpleado() throws MalformedURLException, IOException, KeyManagementException, NoSuchAlgorithmException, Exception{
        new TrustAllSSL().configureTrustAllSSL();
        
        //COLOCAMOS LA URL PARA ENVIAR EL MENSAJE
        URL url = new URL(this.URL);
        //INICIALIZAMOS EL CONTENEDOR DEL ENVIO
        HttpURLConnection httpConn = (HttpURLConnection) url.openConnection();
        //EL TIPO DE ENVIO DE DATOS VA A SER VIA POST
        httpConn.setRequestMethod("POST");
        //CODIGO DE AUTORIZACION DE JAVA
        //httpConn.setRequestProperty("Authorization", "Bearer " + this.WA_TOKEN);
        //DEFINIMOS QUE LOS DATOS SERAN TRATADOS COMO JSON
        httpConn.setRequestProperty("Content-Type", "application/json");
        //PREPARAMOS Y ENVIAMOS EL JSON
        httpConn.setDoOutput(true);
        try (OutputStreamWriter writer = new OutputStreamWriter(httpConn.getOutputStream())) {
            writer.write("{\"name\": \"Pedro\",\"job\": \"Developer\"}");
            //LIMPIAMOS LOS DATOS
            writer.flush();
        }
        //CERRAMOS LA CONEXION
        httpConn.getOutputStream().close();
        //RECIBIMOS EL RESULTADO DEL ENVIO
        InputStream responseStream = httpConn.getResponseCode() / 100 == 2
                ? httpConn.getInputStream()
                : httpConn.getErrorStream();
        Scanner s = new Scanner(responseStream).useDelimiter("\\A");
        //OBTENEMOS LOS RESULTADOS
        String respuesta = s.hasNext() ? s.next() : "";
        System.out.print("Respuesta del servidor: " + respuesta);
    }//end metod
}
