package amx.ccie.etl.dao;

import amx.ccie.etl.util.BitacoraDTO;
import amx.ccie.etl.util.Conexion;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.jdbc.OracleTypes;

/**
 *
 * @author montielj
 */
public class BitacoraDAO extends Conexion {
    
    public List<BitacoraDTO> getBitacora() {
        List<BitacoraDTO> data = new ArrayList<>();
        StringBuilder sql = new StringBuilder();
        sql.append("{call ").append(getEsq_amx()).append(getPkg_pref()).append("UTIL.").append("USP_GET_CATALOGOS").append("(?,?,?)}");
        try (Connection conn = getConnection();
            CallableStatement cs = conn.prepareCall(sql.toString())) {
            
            cs.registerOutParameter(1, OracleTypes.CURSOR); // CURSOR_OUT
            cs.registerOutParameter(2, OracleTypes.INTEGER); // ESTATUS_OUT
            cs.registerOutParameter(3, OracleTypes.VARCHAR); // MSG_OUT

            cs.execute();

            int estatus = cs.getInt(2);
            if (estatus == 1) { // Éxito
                try (ResultSet rs = (ResultSet) cs.getObject(1)) {
                    while (rs.next()) {
                        BitacoraDTO dto = new BitacoraDTO();
                        dto.setId(rs.getInt("id"));
                        dto.setDescripcion(rs.getString("clave"));
                        dto.setEstatus(rs.getInt("estatus"));
                        data.add(dto);
                    }
                }
            } else {
                throw new SQLException(cs.getString(3));
            }

        } catch (SQLException e) {
            e.printStackTrace(); // Manejo de errores
        }
        return data;
    }
    
}
