package amx.ccie.etl.dao;


import amx.ccie.dto.CatalogoDTO;
import amx.ccie.etl.util.Conexion;
import oracle.jdbc.OracleTypes;

import java.sql.*;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author montielj
 */
public class CatalogosDAO extends Conexion {

    // Método genérico para realizar consultas
    private List<CatalogoDTO> ejecutarConsulta(String store, int id) {
        List<CatalogoDTO> data = new ArrayList<>();
        StringBuilder sql = new StringBuilder();
        sql.append("{call ").append(getEsq_amx()).append(getPkg_pref()).append("CATALOGOS.").append(store).append("(?,?,?,?)}");
        try (Connection conn = getConnection();
             CallableStatement cs = conn.prepareCall(sql.toString())) {
            cs.setString(1, "Prueba entrada Catalogo");
            cs.setInt(2, id); // ID_IN
            cs.registerOutParameter(3, OracleTypes.INTEGER); // ESTATUS_OUT
            cs.registerOutParameter(4, OracleTypes.VARCHAR); // MSG_OUT

            cs.execute();

            int estatus = cs.getInt(3);
            if (estatus != 1) { // Éxito
                throw new SQLException(cs.getString(4));
            }

        } catch (SQLException e) {
            e.printStackTrace(); // Manejo de errores
        }
        return data;
    }

    // Métodos específicos para cada tabla
    public List<CatalogoDTO> crearCanalAtencion(int id) {
        return ejecutarConsulta("crear_canal_atencion", id);
    }
    
}

