/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 * Click nbfs://nbhost/SystemFileSystem/Templates/Classes/Class.java to edit this template
 */
package amx.ccie.etl.dao;

import amx.ccie.dto.CorreosDTO;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/**
 *
 * @author montielj
 */
public class CorreosDAO {
    
    private final Logger log = LogManager.getLogger(this.getClass());
    
    /**
     * Método que envía correo electrónico con reporte de activaciones
     *
     * @author José Francisco Montiel Jiménez
     * @param nombre	: Nombre del destinatario
     * @since 09/01/2025
     */
    public void enviaCorreoReporteActivaciones(String nombre) {
        CorreosDTO ndto = new CorreosDTO();
        ndto.setSUBJECT("Notificacion de funcionamiento de catalgos");
        ndto.setBODY(String.join(System.getProperty("line.separator"),
                "<style type=\"text/css\">span{font-weight: bold;}</style>",
                "<div>",
                "<div>",
                "<p>Hola mundo correos</p>",
                "</div>",
                "</div>"
        ));
        ndto.setTO(new String[]{"coronillad@globalhitss.com","montielj@globalhitss.com"});
        configuraEnviaMail(ndto);
        
    }
    
    /**
     * *
     * Envia el correo electronico
     *
     * @param ndto objeto de configuración de email
     * @author David Coronilla
     * @since 25/01/2020
     */
    public void configuraEnviaMail(CorreosDTO ndto) {
        try {
            InternetAddress[] ToList = new InternetAddress[0];
            if (!ndto.getTO()[0].equals("NA")) {
                ToList = new InternetAddress[ndto.getTO().length];
                for (int i = 0; i < ToList.length; i++) {
                    ToList[i] = new InternetAddress(ndto.getTO()[i]);
                }
            }//end if TO

            Properties prop = System.getProperties();
            prop.put("mail.smtp.host", ndto.getHOST());
            prop.put("mail.smtp.port", ndto.getPORT());

            Session session = Session.getDefaultInstance(prop, null);

            MimeMessage msg = new MimeMessage(session);
            msg.addHeader("Content-type", "text/html; charset=UTF-8");
            msg.setFrom(new InternetAddress(ndto.getFROM(), ndto.getFROMNAME()));
            if (!ndto.getTO()[0].equals("NA")) {
                msg.setRecipients(Message.RecipientType.TO, ToList);
            }
            msg.setSubject(ndto.getSUBJECT(), "utf-8");
            msg.setContent(ndto.getBODY(), "text/html");
            Transport.send(msg);
            
            log.info("*** Inicia Datos Correo Normal ***");
            if (ndto.getTO() != null && ndto.getTO().length > 0) {
            	log.info("Correo enviado a: ");
                for (String correo : ndto.getTO()) {
                	log.info("    " + correo);
                }
            }            

            if (ndto.getCC() != null && ndto.getCC().length > 0) {
            	log.info("Correo CC enviado a: ");
                for (String correo : ndto.getCC()) {
                	log.info("    " + correo);
                }
            }
            
            if (ndto.getCCO() != null && ndto.getCCO().length > 0) {
            	log.info("Correo CCO enviado a: ");
                for (String correo : ndto.getCCO()) {
                	log.info("    " + correo);
                }
            }
            log.info("Título del correo: "+ndto.getSUBJECT());
            log.info("*** Termina Datos Correo Normal ***");
        } catch (UnsupportedEncodingException | MessagingException ex) {
            log.error("No se envio.");
            log.error("Error: ", ex);
        }
    }//end method  
    
}
