package com.mx.dla.dda.contrato.bos;

import java.sql.SQLException;

import javax.xml.ws.WebServiceException;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.soap.client.SoapFaultClientException;

import com.americamovil.dda.enviaentradamercancia.DTEntradaMercancia;
import com.americamovil.dda.enviaentradamercancia.DTEntradaMercanciaRes;
import com.americamovil.dda.enviapedidocompra.DTPedidoCompra;
import com.americamovil.dda.enviapedidocompra.DTPedidoCompraRes;
import com.mx.dla.dda.contrato.daos.EnviaMercanciaDAO;
import com.mx.dla.dda.contrato.daos.OrdenCompraDAO;
import com.mx.dla.dda.contrato.dtos.MercanciaI32DTO;
import com.mx.dla.dda.contrato.dtos.MercanciaI32DetDTO;
import com.mx.dla.dda.contrato.dtos.OrdenCompraDetI8DTO;
import com.mx.dla.dda.contrato.dtos.OrdenCompraI8DTO;
import com.mx.dla.dda.contrato.trans.TransformaSAPToDDA;
import com.mx.dla.dda.contrato.trans.VerificarDatosDDA;


@Component
@PropertySource("classpath:interfaces.properties")
public class OrdenCompraBO {
	
	final static Logger logger = Logger.getLogger(OrdenCompraBO.class);
		
	@Autowired
	private OrdenCompraDAO ordenCompraDAO;
	
	@Autowired
	private EnviaMercanciaDAO enviaMercanciaDAO;

	@Autowired
	@Qualifier("wsLogin")
	private WebServiceTemplate wsLogin; 

	@Autowired
	private Environment env;
						
	public OrdenCompraI8DTO crearOrdenCompra(DTPedidoCompra param) throws Exception{			
			String error = "OK";
		    DTPedidoCompraRes response = new DTPedidoCompraRes();
		    OrdenCompraI8DTO request = null;
		    boolean creado = false;
		    		    		    		    
		    try{		    			    		
		    	if(this.verificarI8(param))
		    	{
		    		error = VerificarDatosDDA.verificarOrdenCompraI8(param);

		    		//Se llama al servicio web de sap		    	
			    	response = (DTPedidoCompraRes) wsLogin.marshalSendAndReceive(this.getWsdl("8"), param);
			    			    	
			    	//se hacce transformacion de dominios
			    	request = TransformaSAPToDDA.getOrdenCompra(param,response);
			    	request.setEstatusDDA(error);
			    	ordenCompraDAO.crearOrdenCompra(request);
			    	
			    	for(OrdenCompraDetI8DTO item : request.getItem()){		    		
			    		item.setIdOrden(request.getIdCompra());		    		
			    		ordenCompraDAO.crearOrdenCompra_Det(item);
			    	}		    		
			    	creado = true;
		    	}
		    	else{		    		
		    		error = "DDA-201";
		    	}
		    }catch(SQLException sql){			
				error = "DDA-101";		    
		    	logger.error("Error guardar bd.",sql);
		    	throw new Exception("Error guardar bd.",sql);		    	
			}catch(WebServiceException c){
		    	error = "DDA-301";		    	
		    	logger.error("Error Comunicacion web service.",c);
		    	throw new Exception("Error Comunicacion web service.",c);
		    }catch(SoapFaultClientException se){		    	
		    	error = "DDA-302";
		    	logger.error("Error Interno en SAP. ",se);			    			    			    			    			    
		    	throw new Exception("Error Interno en SAP.",se);
		    }catch(Exception e){
		    	error = "DDA-501";		    	
		    	logger.error("Error proceso.",e);
		    	throw new Exception("Error proceso.",e);		    	
		    }finally{		  
		    	if(!creado){
		    		request = TransformaSAPToDDA.getOrdenCompra(param, null);		    		
		    		request.setEstatusDDA(error);		    		
			    	ordenCompraDAO.crearOrdenCompra(request);
			    	
			    	for(OrdenCompraDetI8DTO item : request.getItem()){		    		
			    		item.setIdOrden(request.getIdCompra());		    		
			    		ordenCompraDAO.crearOrdenCompra_Det(item);
			    	}	
		    	}			    			    
		    }
			    	    
		    return request;		    
	}

	public boolean verificarI8(DTPedidoCompra param){
		    boolean check = true;
		   
			for(DTPedidoCompra.PedidoCompra.Item item : param.getPedidoCompra().getItem()){
				if( (item.getIIDOrden() == null && item.getICentroCoste() == null) || 
					(item.getIIDOrden().equals("") && item.getICentroCoste().equals("")) )					
					check = false;
			}
			logger.info("validacion"+check);
		   return check;
	}
	
	public MercanciaI32DTO entradaMercancia(DTEntradaMercancia param)throws Exception{		
		String error = "OK";
		MercanciaI32DTO request = new MercanciaI32DTO();
		DTEntradaMercanciaRes response = new DTEntradaMercanciaRes();
		boolean creado = false;
		try{			
			error = VerificarDatosDDA.verificarMercanciaI32(param);
			
			logger.info("URL WS: " + this.getWsdl("32") );
			
		    //Se llama al servicio web de sap		    
	    	response = (DTEntradaMercanciaRes) wsLogin.marshalSendAndReceive(this.getWsdl("32"), param);
	    	
	    	if( response.getRespuesta().getDocMaterial().equals("") )
	    	{
	    		error = "DDA-303";
	    		logger.error("SAP no regreso el numero del documento");
	    	}
	    	
	    	//se hace la transformacion de dominios								
		    request = TransformaSAPToDDA.getMercanciaI32DTO(param, response);
		    request.setEstatusDDA(error);
		    enviaMercanciaDAO.entradaMercancia(request);
		    
		    for(MercanciaI32DetDTO item : request.getItem()){
	    		item.setIdMercancia(request.getIdMercancia());
	    		enviaMercanciaDAO.entradaMercanciaDet(item);
	    	}		    	   
		    creado = true;
		}catch(SQLException sql){			
			error = "DDA-101";	    	
	    	logger.error("Error guardar bd.",sql);
	    	throw new Exception("Error guardar bd.",sql);		    	
		}catch(WebServiceException c){
	    	error = "DDA-301";	    	
	    	logger.error("Error Comunicacion web service.",c);
	    	throw new Exception("Error Comunicacion web service.",c);
	    }catch(SoapFaultClientException se){	    	
	    	error = "DDA-302";
	    	logger.error("Error Interno en SAP. ",se);			    			    			    			    			    
	    	throw new Exception("Error Interno en SAP.",se);
	    }catch(Exception e){
	    	error = "DDA-501";	    	
	    	logger.error("Error proceso.",e);
	    	throw new Exception("Error proceso.",e);		    	
	    }finally{	    	
	    	if(!creado){
	    		request = TransformaSAPToDDA.getMercanciaI32DTO(param, new DTEntradaMercanciaRes());
	    		request.setEstatusDDA(error);
			    enviaMercanciaDAO.entradaMercancia(request);
			    
			    for(MercanciaI32DetDTO item : request.getItem()){
		    		item.setIdMercancia(request.getIdMercancia());
		    		enviaMercanciaDAO.entradaMercanciaDet(item);
		    	}		    		
	    	}		    		    	    
	    }
	    return request;
	}
	
	public String getWsdl(String numinterface)throws Exception{	    	    
	    String wsdl = env.getProperty("ddaContratoCWS.clientws.wsdlLocation.i"+numinterface);	 	    
	    return wsdl;
	}	
}
