package com.mx.dla.dda.contrato.ws;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.americamovil.dda.enviaactivofijo.DTActivoFijo;
import com.americamovil.dda.enviaactivofijo.DTTituloMismoValor;
import com.americamovil.dda.enviacontenido.DTContenido;
import com.americamovil.dda.enviaentradamercancia.DTEntradaMercancia;
import com.americamovil.dda.enviamodifactivofijo.DTBajaConPerdida;
import com.americamovil.dda.enviamodifactivofijo.DTBajaSinPerdida;
import com.americamovil.dda.enviamodifactivofijo.DTTituloPorValor;
import com.americamovil.dda.enviamodifactivofijo.DTVidaUtil;
import com.americamovil.dda.envianombreactivof.DTNombreActivoFReq;
import com.americamovil.dda.enviapedidocompra.DTPedidoCompra;
import com.americamovil.dda.enviapostcapitalizacontenido.DTCapitalizaContenido;
import com.mx.dla.dda.contrato.bos.ActivoFijoBO;
import com.mx.dla.dda.contrato.bos.OrdenCompraBO;
import com.mx.dla.dda.contrato.dtos.ActivoFijoI10DTO;
import com.mx.dla.dda.contrato.dtos.ActivoFijoI12DTO;
import com.mx.dla.dda.contrato.dtos.ActivoFijoI19DTO;
import com.mx.dla.dda.contrato.dtos.ActivoFijoI20DTO;
import com.mx.dla.dda.contrato.dtos.ActivoFijoI25DTO;
import com.mx.dla.dda.contrato.dtos.ActivoFijoI27DTO;
import com.mx.dla.dda.contrato.dtos.ActivoFijoI29DTO;
import com.mx.dla.dda.contrato.dtos.ActivoFijoI30DTO;
import com.mx.dla.dda.contrato.dtos.ActivoFijoI31DTO;
import com.mx.dla.dda.contrato.dtos.MercanciaI32DTO;
import com.mx.dla.dda.contrato.dtos.OrdenCompraI8DTO;

@Controller
@RequestMapping("/")
public class ContratoRest {
	
	final static Logger logger = Logger.getLogger(OrdenCompraBO.class);
	
	@Autowired	
	private OrdenCompraBO ordenCompraBO;
	
	@Autowired
	private ActivoFijoBO activoFijoBO;

	@RequestMapping(value = "/crearOrdenCompra", 
			        method = RequestMethod.POST, 
			        headers = "Accept=application/json; charset=utf-8", 
			        produces = {"application/xml", "application/json" })
	@ResponseBody
	public OrdenCompraI8DTO ordenCompra(@RequestBody DTPedidoCompra param) {
		
		OrdenCompraI8DTO response = new OrdenCompraI8DTO();
		logger.info("Inicia RWS I8");		
		
		try {											
			
			response = ordenCompraBO.crearOrdenCompra(param);
			
		}catch(Exception e){						
			logger.error("Error en el Rest.",e);			
		}
		
		logger.info("Termina RWS I8");
		return response;
	}
	
	@RequestMapping(value = "/crearActivoFijo", 
	                method = RequestMethod.POST, 
	                headers = "Accept=application/json; charset=utf-8", 
	                produces = {"application/xml", "application/json" })
	@ResponseBody
	public List<ActivoFijoI10DTO> crearActivoFijo(@RequestBody DTActivoFijo itemr) {

		   List<ActivoFijoI10DTO> response = new ArrayList<ActivoFijoI10DTO>();
		   
		   try {
			logger.info("Inicia cws I10");
		    	    			 
			response = activoFijoBO.crearActivoFijo(itemr);
								
		   }catch(Exception e){			   
			   logger.error("Error en el Rest.",e);
		   }		   
		   logger.info("Termina cws I10");
		   return response;
	}
	
	@RequestMapping(value = "/notificarActivoFijo", 
	                method = RequestMethod.POST, 
	                headers = "Accept=application/json; charset=utf-8", 
	                produces = {"application/xml", "application/json" })
	@ResponseBody
	public List<ActivoFijoI12DTO> notificarActivoFijo(@RequestBody DTContenido param) {
			
		    List<ActivoFijoI12DTO> response = new ArrayList<ActivoFijoI12DTO>();
			
			logger.info("Inicia Proceo CWS I12");
			try {
														
				response = activoFijoBO.notificarActivoFijo(param);
				
			}catch(Exception e){
				logger.error("Error en el Rest.",e);
			}
			logger.info("Fin Proceo CWS I12");
			return response;
	}
	
	@RequestMapping(value = "/postcapitalizarActivoFijo", 
	        method = RequestMethod.POST, 
	        headers = "Accept=application/json; charset=utf-8", produces = {"application/xml", "application/json" })
	@ResponseBody
	public ActivoFijoI19DTO postcapitalizarActivoFijo(@RequestBody DTCapitalizaContenido item) {
	
		    ActivoFijoI19DTO response = new ActivoFijoI19DTO();
		    logger.info("Inicia Proceo CWS I19");
			try {
																			
				response = activoFijoBO.postcapitalizarActivoFijo(item);
											
			}catch(Exception e){	
				logger.error("Error en el CR.",e);
			}
			
			logger.info("Fin Proceo CWS I19");
			return response;
	}
	
	@RequestMapping(value = "/notificarNuevoTitulo", 
	        method = RequestMethod.POST, 
	        headers = "Accept=application/json; charset=utf-8", produces = {"application/xml", "application/json" })
	@ResponseBody
	public ActivoFijoI20DTO notificarNuevoTitulo(@RequestBody DTNombreActivoFReq item) {
	
		    ActivoFijoI20DTO response = new ActivoFijoI20DTO();
		    logger.info("Inicia Proceo CWS I20");
			try {						
												
				response = activoFijoBO.notificarNuevoTitulo(item);
											
			}catch(Exception e){	
				   logger.error("Error en el Rest.",e);
			}
			
			logger.info("Fin Proceo CWS I20");
			return response;
	}

	@RequestMapping(value = "/trasladarActivoFijo", 
	        method = RequestMethod.POST, 
	        headers = "Accept=application/json; charset=utf-8", produces = {"application/xml", "application/json" })
	@ResponseBody
	public ActivoFijoI25DTO trasladarActivoFijo(@RequestBody DTTituloMismoValor item) {
	
		    ActivoFijoI25DTO response = new ActivoFijoI25DTO();
		    logger.info("Inicia Proceo CWS I25");
			try {						
												
				response = activoFijoBO.trasladarActivoFijo(item);
											
			}catch(Exception e){	
				   logger.error("Error en el Rest.",e);
			}
			
			logger.info("Fin Proceo CWS I25");
			return response;
	}
	
	@RequestMapping(value = "/eliminarActivoFijo", 
	        method = RequestMethod.POST, 
	        headers = "Accept=application/json; charset=utf-8", produces = {"application/xml", "application/json" })
	@ResponseBody
	public ActivoFijoI27DTO eliminarActivoFijo(@RequestBody DTTituloPorValor item) {
	
		    ActivoFijoI27DTO response = new ActivoFijoI27DTO();
		    logger.info("Inicia Proceo CWS I27");
			try {						
												
				response = activoFijoBO.eliminarActivoFijo(item);
											
			}catch(Exception e){	
				   logger.error("Error en el Rest.",e);
			}
			
			logger.info("Fin Proceo CWS I27");
			return response;
	}
	
	@RequestMapping(value = "/modificarActivoFijo", 
	        method = RequestMethod.POST, 
	        headers = "Accept=application/json; charset=utf-8", produces = {"application/xml", "application/json" })
	@ResponseBody
	public ActivoFijoI29DTO modificarActivoFijo(@RequestBody DTVidaUtil item) {
	
		    ActivoFijoI29DTO response = new ActivoFijoI29DTO();
		    logger.info("Inicia Proceo CWS I29");
			try {						
												
				response = activoFijoBO.modificarActivoFijo(item);
											
			}catch(Exception e){	
				   logger.error("Error en el Rest.",e);
			}
			
			logger.info("Fin Proceo CWS I29");
			return response;
	}
	
	@RequestMapping(value = "/bajaConPerdidaActivoFijo", 
	        method = RequestMethod.POST, 
	        headers = "Accept=application/json; charset=utf-8", produces = {"application/xml", "application/json" })
	@ResponseBody
	public ActivoFijoI30DTO bajaConPerdidaActivoFijo(@RequestBody DTBajaConPerdida item) {
	
		    ActivoFijoI30DTO response = new ActivoFijoI30DTO();
		    logger.info("Inicia Proceo CWS I30");
			try {						
												
				response = activoFijoBO.bajaConPerdidaActivoFijo(item);
											
			}catch(Exception e){	
				   logger.error("Error en el Rest.",e);
			}
			
			logger.info("Fin Proceo CWS I30");
			return response;
	}
	
	@RequestMapping(value = "/bajaSinPerdidaActivoFijo", 
	        method = RequestMethod.POST, 
	        headers = "Accept=application/json; charset=utf-8", produces = {"application/xml", "application/json" })
	@ResponseBody
	public ActivoFijoI31DTO bajaSinPerdidaActivoFijo(@RequestBody DTBajaSinPerdida item) {
	
			ActivoFijoI31DTO response = new ActivoFijoI31DTO();
		    logger.info("Inicia Proceo CWS I31");
			try {						
												
				response = activoFijoBO.bajaSinPerdidaActivoFijo(item);
											
			}catch(Exception e){	
				   logger.error("Error en el Rest.",e);
			}
			
			logger.info("Fin Proceo CWS I31");
			return response;
	}

	@RequestMapping(value = "/entradaMercancia", 
	        method = RequestMethod.POST, 
	        headers = "Accept=application/json; charset=utf-8", produces = {"application/xml", "application/json" })
	@ResponseBody
	public MercanciaI32DTO entradaMercancia(@RequestBody DTEntradaMercancia param){

		    MercanciaI32DTO response = new MercanciaI32DTO();
		    logger.info(">>>>> Inicia Proceso CWS I32 <<<<<");
			try {						
												
				response = ordenCompraBO.entradaMercancia(param);
											
			}catch(Exception e){	
				   logger.error("Error en el Rest.",e);
			}
			
			logger.info("Fin Proceo CWS I32");
			return response;
	}	
}
