package com.mx.dla.dda.ordenesinternas.bos;

import java.net.MalformedURLException;
import java.net.URL;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ws.client.core.WebServiceTemplate;

import com.americamovil.dda._1.f.enviaordeninterna.DTOrdenInterna;
import com.americamovil.dda._1.f.enviaordeninterna.DTOrdenInternaRes;
import com.americamovil.dda._1.f.enviapresupuestooi.DTPresupuestoOIReq;
import com.americamovil.dda._1.f.enviapresupuestooi.DTPresupuestoOIRes;
import com.mx.dla.dda.ordenesinternas.dtos.OrdenesInternasDTO;
import com.mx.dla.dda.ordenesinternas.dtos.PresupuestoDTO;


@Component
@PropertySource("classpath:interfaces.properties")
public class OrdenesInternasBO {

	private static Logger log = Logger.getLogger(OrdenesInternasBO.class);
	
	private WebServiceTemplate wsLogin; 
	
	@Autowired
	private Environment env;
	
	public OrdenesInternasDTO intentaCrearOrdenInterna(DTOrdenInterna ordenInterna) {
		
		DTOrdenInternaRes respuesta = null;
		OrdenesInternasDTO ordenesInternasDTO = new OrdenesInternasDTO();
				
		try 
		{
			log.info("Inicia proceso de interfaz.");		
			log.info("Url a llamar: " + getWsdlURL("3"));
			log.info("Creacion apartado.");
			log.info("Request:"+ordenInterna.toString());
			
			respuesta = (DTOrdenInternaRes) wsLogin.marshalSendAndReceive(getWsdlURL("3").toString(), ordenInterna);
			
			log.info("Respuesta." + respuesta.toString());
			
			if(respuesta.getRespuesta().size() == ordenInterna.getRegistro().size())			
				for(int i = 0; i < respuesta.getRespuesta().size(); i++){
					ordenesInternasDTO.setEstatus_dda("OK");												
					ordenesInternasDTO.setR_id_sap(respuesta.getRespuesta().get(i).getIDSAP());
				}
			else			
				log.info("Tamao de listas incorrecto.");	
			
			log.info("Resultado." + ordenesInternasDTO);

			
		} catch (Exception e) {
			log.error("Error.");
			for (DTOrdenInterna.Registro registro : ordenInterna.getRegistro()) 				
				ordenesInternasDTO.setEstatus_dda("DDA-301");																		
			log.error(e);			
		}	
		return ordenesInternasDTO;
	}

	@Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
	public PresupuestoDTO intentaModicarOrdenInterna(DTPresupuestoOIReq presupuesto) {

		DTPresupuestoOIRes respuesta = null;
		PresupuestoDTO presupuestoDTO = new PresupuestoDTO();	
		
		log.info("Inicia proceso de interfaz.");		
		log.info("Url a llamar: " + getWsdlURL("7"));
		log.info("Asignacion Presupuesto.");
		log.info("Request:"+presupuesto.toString());		
		
		try {	
			
			respuesta = (DTPresupuestoOIRes) wsLogin.marshalSendAndReceive(getWsdlURL("7").toString(), presupuesto);
									
			log.info("Respuesta." +respuesta.toString());
			
			presupuestoDTO.setEstatus("OK");
			
			log.info("Se termina Proceso");
			
		} catch (Exception e) {
			log.error("Error.");
			presupuestoDTO.setEstatus("DDA-301");						
			log.error(e);			
		}
		
		return presupuestoDTO;
	}
	
	public URL getWsdlURL(String idInterface){
		
		URL url = null;
		
        try {
            url = new URL(env.getProperty("ordenInterna.clientws.wsdlLocation.i" + idInterface));
        } catch (MalformedURLException e) {
        	log.error("No se pudo inicializar el wsdl " + url);
        }       
        return url;
    }

	public Environment getEnv() {
		return env;
	}

	public void setEnv(Environment env) {
		this.env = env;
	}

	public WebServiceTemplate getWsLogin() {
		return wsLogin;
	}
	
	@Autowired
	public void setWsLogin(WebServiceTemplate wsLogin) {
		this.wsLogin = wsLogin;
	}
}