package com.mx.dla.dda.pedidocompra.ws;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.americamovil.dda._1.enviaposicionpo.DTCreaPosicionPOReq;
import com.americamovil.dda._1.enviaposicionpo.DTModificaPosicionPO;
import com.americamovil.dda._1.enviaposicionpo.DTMovimientoFinalPO;
import com.mx.dla.dda.pedidocompra.bos.PedidoCompraBO;
import com.mx.dla.dda.pedidocompra.dtos.DDA_I172334DTO;

@Controller
@RequestMapping("pedidoCompraWS")
public class PedidoCompraWS {

	@Autowired
	private PedidoCompraBO pedidoCompraBO;

	@RequestMapping(value = "/enviaPosicion", method = RequestMethod.POST, headers = "Accept=application/json; charset=utf-8", produces = {
			"application/xml", "application/json" })
	@ResponseBody
	public DDA_I172334DTO enviaPosicion(@RequestBody DTCreaPosicionPOReq posicion) {
		return pedidoCompraBO.consumeEnviaPosicion(posicion);
	}

	@RequestMapping(value = "/enviaMovimientoFinal", method = RequestMethod.POST, headers = "Accept=application/json; charset=utf-8", produces = {
			"application/xml", "application/json" })
	@ResponseBody
	public DDA_I172334DTO enviaMovimientoFinal(@RequestBody DTMovimientoFinalPO movimiento) {
		return pedidoCompraBO.consumeEnviaMovimientoFinal(movimiento);
	}

	@RequestMapping(value = "/enviaModificacionPosicion", method = RequestMethod.POST, headers = "Accept=application/json; charset=utf-8", produces = {
			"application/xml", "application/json" })
	@ResponseBody
	public DDA_I172334DTO enviaModificacionPosicion(@RequestBody DTModificaPosicionPO posicion) {
		return pedidoCompraBO.consumeEnviaModificacionPosicion(posicion);
	}

	public PedidoCompraBO getPedidoCompraBO() {
		return pedidoCompraBO;
	}

	public void setPedidoCompraBO(PedidoCompraBO pedidoCompraBO) {
		this.pedidoCompraBO = pedidoCompraBO;
	}

}
