package com.mx.dla.dda.contrato.pedido.daos;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.mx.dla.dda.contrato.pedido.dtos.ContratoMaterialDTO;
import com.mx.dla.dda.contrato.pedido.dtos.PedidoI37DTO;
import com.mx.dla.dda.contrato.pedido.dtos.PedidoI39DTO;
import com.mx.dla.dda.contrato.pedido.dtos.PedidoI43DTO;

public interface PedidoDAO {

	//interfaz 37
	public void agregarPedido(ContratoMaterialDTO pedido);
	//interfaz 39
	public void notificarEntrada(PedidoI39DTO pedido);
	//interfaz 43
	public void modificarPedido(PedidoI43DTO pedido) ;
	
	
	public ContratoMaterialDTO buscaIdContrato(@Param("licencia")Long licencia);
	
	public ContratoMaterialDTO buscaIdMaterial(@Param("codigoMaterial")String codigoMaterial);
	
	public ContratoMaterialDTO buscaTituloOriginal(@Param("licencia")Long licencia);
	
	public List<ContratoMaterialDTO> buscaContratoMaterial(@Param("params")ContratoMaterialDTO params);
	
	public void creaContratoMaterial(ContratoMaterialDTO param);
	
	public void actualizaContratoMaterial(ContratoMaterialDTO param);
	
	
	
	
	
	//public Long getIdContratoOriginalByOrdenCompra(String ordenCompra);

	
}
