package com.mx.dla.dda.facturacion.daos;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.mx.dla.dda.facturacion.dtos.FacturaSuscriptoresBD;
import com.mx.dla.dda.facturacion.dtos.FacturaTransaccionesBD;
import com.mx.dla.dda.facturacion.dtos.FacturaVerificadaBD;

public interface FacturacionDAO {

	public void notificarPago(FacturaSuscriptoresBD factura);
	public void actualizarPago(FacturaSuscriptoresBD factura);
    public List<FacturaSuscriptoresBD> buscaPagoByOrdenAndDocEm(FacturaSuscriptoresBD factura);
	
	public void actualizarFactura(FacturaTransaccionesBD factura);
	public void updateNotificarPago(FacturaSuscriptoresBD factura);	
	public void notificarFacturaVerificada(FacturaVerificadaBD facturaBD);
	
	public Long getIdContratoOriginalByOrdenCompra(String ordenCompra);
	
	 public List<FacturaVerificadaBD> buscaContratoMaterial(@Param("params")FacturaVerificadaBD params);
	 public void actualizaContratoMaterial(FacturaVerificadaBD factura);
	 
	 public List<FacturaTransaccionesBD> buscarFacturaTransaccional(@Param("transaccion")FacturaTransaccionesBD params);
}
