package com.mx.dla.dda.facturacion.trans;

import java.math.BigDecimal;
import java.util.Date;

import com.mx.dla.dda.bussiness.utilerias.BussinessUtilerias;
import com.mx.dla.dda.facturacion.dtos.FacturaSuscriptoresBD;
import com.mx.dla.dda.facturacion.dtos.FacturaDTO;
import com.mx.dla.dda.facturacion.dtos.FacturaVerificadaBD;
import com.mx.dla.dda.facturacion.dtos.FacturaVerificadaDTO;
import com.mx.dla.dda.facturacion.dtos.RespuestaDTO;
import com.mx.dla.dda.facturacion.dtos.RespuestaFacturaDTO;

public class TransformacionSAPToDDA {

	public static FacturaSuscriptoresBD getFacturaBD(FacturaDTO dto) {
		FacturaSuscriptoresBD factura = new FacturaSuscriptoresBD();

		factura.setSociedad(dto.getSociedad() != null ? dto.getSociedad().trim() : null);
		factura.setAnnio(dto.getAnnio() != null ? dto.getAnnio().trim() : null);
		factura.setDocto_em(dto.getDocto_em() != null ? dto.getDocto_em().trim() : null);
		factura.setDocto_oc(dto.getDocto_oc() != null ? dto.getDocto_oc().trim() : null);
		factura.setImporte(dto.getImporte() != null ? dto.getImporte().trim() : null);
		//factura.setFecha(new Date());
		factura.setNumeroFactura(dto.getNumero_factura() != null ? dto.getNumero_factura().trim() : null);
		factura.setOrdenCompra(dto.getOrden_compra() != null ? dto.getOrden_compra().trim() : null);

		return factura;
	}

	public static FacturaVerificadaBD getFacturaVerificadaBD(FacturaVerificadaDTO dto, RespuestaDTO respuesta) {
		FacturaVerificadaBD factura = new FacturaVerificadaBD();

		String importe = dto.getImporte() != null ? dto.getImporte().trim() : null;

		if (BussinessUtilerias.validaSapNegativo(importe))
			importe = String.valueOf(new BigDecimal(BussinessUtilerias.quitaNegativo(importe)).multiply(new BigDecimal("-1")));

		factura.setImporte(importe);
		factura.setNumDocto(dto.getNumDocto() != null ? dto.getNumDocto().trim() : null);
		factura.setNumFactura(dto.getNumFactura() != null ? dto.getNumFactura().trim() : null);
		factura.setOrdenCompra(dto.getOrdenCompra() != null ? dto.getOrdenCompra().trim() : null);

		factura.setEstatus(respuesta.getEstatus() != null ? respuesta.getEstatus().trim() : null);
		factura.setDescripcion(respuesta.getDescripcion() != null ? respuesta.getDescripcion().trim() : null);
		// factura.setFecha(new Date());

		return factura;
	}

}
