package com.mx.dla.dda.catalogo.material.bos;

import java.sql.SQLException;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import com.mx.dla.dda.catalogo.generales.dtos.RespuestaDTO;
import com.mx.dla.dda.catalogo.material.daos.MaterialDAO;
import com.mx.dla.dda.catalogo.material.dtos.MaterialCollectionDTO;
//import com.mx.dla.dda.catalogo.material.dtos.MaterialDTO;
//import com.mx.dla.dda.catalogo.material.dtos.MaterialI1DTO;
import com.mx.dla.dda.catalogo.material.dtos.TituloDTO;
import com.mx.dla.dda.catalogo.material.dtos.TituloI1DTO;
import com.mx.dla.dda.catalogo.material.trans.TransformaSAPToDDA;

public class MaterialBO {

	@Autowired
	private MaterialDAO materialDAO;
	
	private static Logger log = Logger.getLogger(MaterialBO.class);

	public RespuestaDTO agregaMaterialBO(MaterialCollectionDTO materiales) {
		RespuestaDTO respuesta = null;
		TituloI1DTO materialI1DTO = null;
		Long idMaterial = null;
		boolean valido=true;
		
		for (TituloDTO material : materiales.getMateriales()) {
			log.info("    <<<< Datos del titulo >>>" );				
			log.info( material.toString() );
			
			log.info("    Inicio de la validacion del Titulo:" + material.getCodigoSap() );
			respuesta = validaMaterial(material);
			log.info("    Fin de la validacion del titulo:" + material.getCodigoSap() + " con resultado: " + respuesta.getEstatus() );
			
			if( !respuesta.getEstatus().equals( "OK" ) )	{
				valido=false;
				log.info("Detalle de error: "+respuesta.getDescripcion());
				respuesta.setEstatus("ERROR");
				break;
			}
			
		}
		
		
		
		try {
			
			for (TituloDTO material : materiales.getMateriales()) {
					
				if( valido )	{
					
//					materialI1DTO = TransformaSAPToDDA.getMaterialI1DTO(material);
//					materialI1DTO.setDescripcion(respuesta.getDescripcion());
//					materialI1DTO.setEstatus(respuesta.getEstatus());
//					
//					log.info("    Inicio de la busqueda el ID del material:" + material.getNombre() );
//					idMaterial = materialDAO.obtenerIdMaterial(materialI1DTO.getCodigo());
//					log.info("    Fin de la busqueda ID del material:" + idMaterial );
					
//					if(idMaterial == null){
//						
//						log.info("    Inicio de la insercion del material:" + idMaterial );
//						materialDAO.agregarMaterial(materialI1DTO);
//						log.info("    Fin de la insercion del material:" + idMaterial );
//						
//					}else{
//						
						log.info("    Inicio de la insercion de la amortizacion :" + idMaterial );
//						materialI1DTO.setIdMaterial(idMaterial);
//						materialDAO.actualizaMaterial(materialI1DTO);
//						log.info("    Fin de la actualizacion del material:" + idMaterial );
//						
//					}
				}				
			}					
			
//		} catch (SQLException e) {
//			log.info("Ocurrio un error en agregaMaterialBO");
//			log.info(e.getMessage());
			 
		} catch(Exception e){
			log.info("Ocurrio un error en agregaMaterialBO");
			log.info(e.getMessage());
		}
		return respuesta;
	}

	private RespuestaDTO validaMaterial(TituloDTO material){
		RespuestaDTO respuesta = new RespuestaDTO();
		
		respuesta.setEstatus("OK");
		respuesta.setDescripcion("Datos registrados correctamente");
		
		if(material.getCodigoSap() == null || material.getCodigoSap().equals("")){
			respuesta.setEstatus("DDA-201");
			respuesta.setDescripcion("Falta parmetro codigo");
		}else if(material.getCodigoSap().length() > 12){
			respuesta.setEstatus("DDA-202");
			respuesta.setDescripcion("El parmetro [codigoSAP] excede tamao");
			material.setCodigoSap(material.getCodigoSap().substring(0, 12));
		}
		
		if(material.getSubNumero() == null || material.getSubNumero().equals("")){
			respuesta.setEstatus("DDA-203");
			respuesta.setDescripcion("Falta parmetro subNumero");
		}else if(material.getSubNumero().length() > 6){
			respuesta.setEstatus("DDA-204");
			respuesta.setDescripcion("El parmetro [subNumero] excede tamao");
			material.setSubNumero(material.getSubNumero().substring(0, 6));
		}
		
		if(material.getCodigoDDA() == null || material.getCodigoDDA().equals("")){
			respuesta.setEstatus("DDA-205");
			respuesta.setDescripcion("Falta parmetro CodigoDDA");
		}else if(material.getCodigoDDA().length() > 10){
			respuesta.setEstatus("DDA-206");
			respuesta.setDescripcion("El parmetro [CodigoDDA] excede tamao");
			material.setSubNumero(material.getCodigoDDA().substring(0, 10));
		}
		
				
		if( material.getAmortizacionMes() != null && !material.getAmortizacionMes().equals("") && material.getAmortizacionMes().length() > 30){
			respuesta.setEstatus("DDA-207");
			respuesta.setDescripcion("El parmetro AmortizacionMes es invalido");
			material.setAmortizacionMes(material.getAmortizacionMes().substring(0, 30));
		}
		
		if(material.getAmortizacionAcumulada() == null || material.getAmortizacionAcumulada().equals("")){
			respuesta.setEstatus("DDA-208");
			respuesta.setDescripcion("Falta parmetro AmortizacionAcumulada");
		}else if(material.getAmortizacionAcumulada().length() > 30){
			respuesta.setEstatus("DDA-209");
			respuesta.setDescripcion("El parmetro [AmortizacionAcumulada] excede tamao");
			material.setAmortizacionAcumulada(material.getAmortizacionAcumulada().substring(0, 30));
		}
		
		if(material.getAmortizacionAcumuladaIE() == null || material.getAmortizacionAcumuladaIE().equals("")){
			respuesta.setEstatus("DDA-210");
			respuesta.setDescripcion("Falta parmetro AmortizacionAcumuladaIE");
		}else if(material.getAmortizacionAcumuladaIE().length() > 30){
			respuesta.setEstatus("DDA-211");
			respuesta.setDescripcion("El parmetro [AmortizacionAcumuladaIE] excede tamao");
			material.setAmortizacionAcumuladaIE(material.getAmortizacionAcumuladaIE().substring(0, 30));
		}
		
		if(material.getCostoTotal() == null || material.getCostoTotal().equals("")){
			respuesta.setEstatus("DDA-212");
			respuesta.setDescripcion("Falta parmetro CostoTotal");
		}else if(material.getCostoTotal().length() > 30){
			respuesta.setEstatus("DDA-213");
			respuesta.setDescripcion("El parmetro [unidad] excede tamao");
			material.setCostoTotal(material.getCostoTotal().substring(0, 30));
		}
		
	
		return respuesta;
	}
}
