package com.mx.dla.dda.catalogo.estudio.ws;

import javax.jws.WebService;
import javax.ws.rs.Path;

import org.apache.log4j.Logger;

import com.mx.dla.dda.catalogo.estudio.bos.EstudioBO;
import com.mx.dla.dda.catalogo.estudio.dtos.EstudioCollectionDTO;
import com.mx.dla.dda.catalogo.generales.dtos.RespuestaDTO;

@WebService(endpointInterface = "com.mx.dla.dda.catalogo.estudio.ws.IEstudioWS", serviceName = "idabmlEstudio")
public class EstudioWS implements IEstudioWS {

	private static Logger log = Logger.getLogger(EstudioWS.class);
	private EstudioBO estudioBO;

	@Override
	@Path("/agregarEstudios")
	public RespuestaDTO agregarEstudios(EstudioCollectionDTO parametro) {
		RespuestaDTO respuesta = new RespuestaDTO();
		respuesta.setEstatus("ERROR");

		try {
			
			log.info("------- Inicio de WS de carga de Estudios -------");
			respuesta = estudioBO.agregaEstudioBO(parametro);	
			if(!respuesta.getEstatus().equals("OK")) respuesta.setEstatus("ERROR");
			log.info("------- Fin de WS de carga de Estudios -------");
			
		} catch (Exception exc) {
			log.info("Ocurrio un error en agregarEstudios");
			log.info(exc.getMessage());
		}

		return respuesta;
	}

	public EstudioBO getEstudioBO() {
		return estudioBO;
	}

	public void setEstudioBO(EstudioBO estudiosBO) {
		this.estudioBO = estudiosBO;
	}

}
