package com.mx.dla.dda.contrato.bos;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.xml.ws.WebServiceException;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.soap.client.SoapFaultClientException;

import com.americamovil.dda.enviaactivofijo.DTActivoFijo;
import com.americamovil.dda.enviaactivofijo.DTActivoFijoRes;
import com.americamovil.dda.enviaactivofijo.DTTituloMismoValor;
import com.americamovil.dda.enviacontenido.DTContenido;
import com.americamovil.dda.enviacontenido.DTContenidoRes;
import com.americamovil.dda.enviamodifactivofijo.DTBajaConPerdida;
import com.americamovil.dda.enviamodifactivofijo.DTBajaSinPerdida;
import com.americamovil.dda.enviamodifactivofijo.DTModificaAFRes;
import com.americamovil.dda.enviamodifactivofijo.DTTituloPorValor;
import com.americamovil.dda.enviamodifactivofijo.DTVidaUtil;
import com.americamovil.dda.envianombreactivof.DTNombreActivoFReq;
import com.americamovil.dda.envianombreactivof.DTNombreActivoFRes;
import com.americamovil.dda.enviapostcapitalizacontenido.DTCapitalizaContenido;
import com.americamovil.dda.enviapostcapitalizacontenido.DTCapitalizaContenidoRes;
import com.mx.dla.dda.contrato.daos.ActivoFijoDAO;
import com.mx.dla.dda.contrato.dtos.ActivoFijoI10DTO;
import com.mx.dla.dda.contrato.dtos.ActivoFijoI12DTO;
import com.mx.dla.dda.contrato.dtos.ActivoFijoI19DTO;
import com.mx.dla.dda.contrato.dtos.ActivoFijoI20DTO;
import com.mx.dla.dda.contrato.dtos.ActivoFijoI25DTO;
import com.mx.dla.dda.contrato.dtos.ActivoFijoI27DTO;
import com.mx.dla.dda.contrato.dtos.ActivoFijoI29DTO;
import com.mx.dla.dda.contrato.dtos.ActivoFijoI30DTO;
import com.mx.dla.dda.contrato.dtos.ActivoFijoI31DTO;
import com.mx.dla.dda.contrato.trans.TransformaSAPToDDA;
import com.mx.dla.dda.contrato.trans.VerificarDatosDDA;

@Component
@PropertySource("classpath:interfaces.properties")
public class ActivoFijoBO {

	final static Logger logger = Logger.getLogger(OrdenCompraBO.class);
	
	@Autowired
	private ActivoFijoDAO activoFijoDAO;
	
	@Autowired
	@Qualifier("wsLogin")
	private WebServiceTemplate wsLogin; 

	@Autowired
	private Environment env;
		
	/*@See Implementacion interfaz 10	 
	 */	
	public List<ActivoFijoI10DTO> crearActivoFijo(DTActivoFijo param) throws Exception{		
			
		DTActivoFijoRes response = new DTActivoFijoRes();		
		List<ActivoFijoI10DTO> request = new ArrayList<ActivoFijoI10DTO>();
		String error = "OK";
		boolean creado = false;
		
		try{											   	    	    	
			logger.info("WS10 Numero Peticiones:"+param.getRegistro().size());
	    		    	    
	    	//Se verifica los tipos de datos			
			error = VerificarDatosDDA.verificarActivoFijoI10(param);   
			
			//Se llama al servicio web de sap
	    	response = (DTActivoFijoRes) wsLogin.marshalSendAndReceive(this.getWsdl("10"), param);	    	
	        
		    //se actualiza la respuesta y se persiste en base datos
	    	logger.info("WS10 Numero Respuestas:"+response.getRespuesta().size());
	    	
	    	if(response.getRespuesta().size() == param.getRegistro().size())
	    	{	    		
			    for(int i=0; i < response.getRespuesta().size(); i++)
			    {			    	
			    	ActivoFijoI10DTO item = TransformaSAPToDDA.getActivoFijoI10DTO(param.getRegistro().get(i), 
			    			                                                       response.getRespuesta().get(i));
			    	item.setEstatusDDA(error);
			    	activoFijoDAO.crearActivoFijo(item);
			    	request.add(item);
			    }
			    creado = true;
	    	}
	    	else
	    		throw new Exception("El numero de respuestas es diferente al de peticiones.");	    	
			
		}catch(SQLException sql){			
			error = "DDA-101";	    
	    	logger.error("Error guardar bd.",sql);
	    	throw new Exception("Error guardar bd.",sql);		    	
		}catch(WebServiceException c){
	    	error = "DDA-301";	    	
	    	logger.error("Error Comunicacion web service.",c);
	    	throw new Exception("Error Comunicacion web service.",c);
	    }catch(SoapFaultClientException se){	    	
	    	error = "DDA-302";
	    	logger.error("Error Interno en SAP. ",se);			    			    			    			    			    
	    	throw new Exception("Error Interno en SAP.",se);
	    }catch(Exception e){
	    	error = "DDA-501";	    	
	    	logger.error("Error proceso.",e);
	    	throw new Exception("Error proceso.",e);		    	
	    }
		finally{		    	
	    	for(int i=0; i < param.getRegistro().size(); i++){			   				   	
			   	if(!creado){
			   		ActivoFijoI10DTO item = TransformaSAPToDDA.getActivoFijoI10DTO(param.getRegistro().get(i),
					   			                               new DTActivoFijoRes.Respuesta());
			   		item.setEstatusDDA(error);
			   		activoFijoDAO.crearActivoFijo(item);
			   	}		
		    }	    	
	    }
	
	    return request;		
	}
	
	/*@See Implementacion interfaz 12	 
	 */
	public List<ActivoFijoI12DTO> notificarActivoFijo(DTContenido param)throws Exception{				
		List<ActivoFijoI12DTO> request = new ArrayList<ActivoFijoI12DTO>();
		DTContenidoRes response = new DTContenidoRes();		
		String error = "OK";
		boolean creado = false;
		try{
			
	    	//Se verifica los tipos de datos			
			error = VerificarDatosDDA.verificarActivoFijoI12(param);   

	        //Se llama al servicio web de sap	 
	    	logger.info("se llama servicio");	    	
	    	response = (DTContenidoRes) wsLogin.marshalSendAndReceive(this.getWsdl("12"), param);
	    	    	
	    	logger.info("respuestas"+ response.getRespuesta().size());
		    //se guarda en la base de datos la respuesta 		 
	    	if(response.getRespuesta().size() == param.getRegistro().size())
	    	{
			    for(int i=0; i< response.getRespuesta().size();i++)
			    {			    	
			    	ActivoFijoI12DTO item = TransformaSAPToDDA.getActivoFijoI12DTO(param.getRegistro().get(i),
			    																   response.getRespuesta().get(i));
			    	item.setEstatusDDA(error);
			    	activoFijoDAO.notificarActivoFijo(item);	
			    	request.add(item);
			    }
			    creado = true;
	    	}
	    	else
	    		throw new Exception("El numero de respuestas es diferente al de peticiones.");
	    
		}catch(SQLException sql){			
			error = "DDA-101";	    	
	    	logger.error("Error guardar bd.",sql);
	    	throw new Exception("Error guardar bd.",sql);		    	
		}catch(WebServiceException c){
	    	error = "DDA-301";	    	
	    	logger.error("Error Comunicacion web service.",c);
	    	throw new Exception("Error Comunicacion web service.",c);
	    }catch(SoapFaultClientException se){	    	
	    	error = "DDA-302";
	    	logger.error("Error Interno en SAP. ",se);			    			    			    			    			    
	    	throw new Exception("Error Interno en SAP.",se);
	    }catch(Exception e){
	    	error = "DDA-501";
	    	e.printStackTrace();
	    	logger.error("Error proceso.",e);
	    	throw new Exception("Error proceso.",e);		    	
	    }finally{	    		
	    	if(!creado){
	    		for(int i=0; i< response.getRespuesta().size();i++){
	    			ActivoFijoI12DTO item = TransformaSAPToDDA.getActivoFijoI12DTO(param.getRegistro().get(i),
							   														new DTContenidoRes.Respuesta());
	    			item.setEstatusDDA(error);
	    			activoFijoDAO.notificarActivoFijo(item);		    							   	
			    }	    	
	    	}
	    }
	    return request;
	}
	
	/*@See Implementacion interfaz 19	 
	 */
	public ActivoFijoI19DTO postcapitalizarActivoFijo(DTCapitalizaContenido param)throws Exception{				
		ActivoFijoI19DTO request = new ActivoFijoI19DTO();
		DTCapitalizaContenidoRes response = new DTCapitalizaContenidoRes();
		String error = "OK";
		boolean creado = false;	    
		try{		    
			//se validan los datos
			error = VerificarDatosDDA.verificarActivoFijoI19(param.getRegistro());
			
		    //Se llama al servicio web de sap						
	    	response = (DTCapitalizaContenidoRes) wsLogin.marshalSendAndReceive(this.getWsdl("19"), param);
		    
		    //se guarda en la base de datos la respuesta		    		    
	    	request = TransformaSAPToDDA.getActivoFijoI19DTO(param.getRegistro(),response.getRespuesta());
	    	request.setEstatusDDA(error);
	    	activoFijoDAO.postcapitalizarActivoFijo(request);
	    	creado = true;
				    			    		   		    		    
		}catch(SQLException sql){			
			error = "DDA-101";	    	
	    	logger.error("Error guardar bd.",sql);
	    	throw new Exception("Error guardar bd.",sql);		    	
		}catch(WebServiceException c){
	    	error = "DDA-301";	    	
	    	logger.error("Error Comunicacion web service.",c);
	    	throw new Exception("Error Comunicacion web service.",c);
	    }catch(SoapFaultClientException se){	    		    
	    	logger.error("Error Interno en SAP. ",se);			    			    			    			    			    
	    	throw new Exception("Error Interno en SAP.",se);
	    }catch(Exception e){
	    	error = "DDA-501";	    	
	    	logger.error("Error proceso.",e);
	    	throw new Exception("Error proceso.",e);		    	
	    }finally{	    	
	    	if(!creado){		    	
	    		request = TransformaSAPToDDA.getActivoFijoI19DTO(param.getRegistro(),new DTCapitalizaContenidoRes.Respuesta());
	    		request.setEstatusDDA(error);
		    	activoFijoDAO.postcapitalizarActivoFijo(request);	    					    		    	    		
	    	}
	    }
    
	    return request;		
	}
		
	/*@See Implementacion interfaz 20 
	 */	
	public ActivoFijoI20DTO notificarNuevoTitulo(DTNombreActivoFReq param)throws Exception{			
		ActivoFijoI20DTO request = null;
		DTNombreActivoFRes response = new DTNombreActivoFRes();
		String error = "OK";
		boolean creado = false;
		
		try{
			//se validan los datos
			error = VerificarDatosDDA.verificarActivoFijoI20(param);
			
			//se llama al Servicios
	    	response = (DTNombreActivoFRes) wsLogin.marshalSendAndReceive(this.getWsdl("20"), param);
	    	
	    	request = TransformaSAPToDDA.getActivoFijoI20DTO(param, response.getRespuesta());
	    	request.setEstatusDDA(error);
	    	activoFijoDAO.notificarNuevoTitulo(request);
	        creado = true;		    		    		  		    		    		   		    		    		    
		}catch(SQLException sql){			
			error = "DDA-101";	    	
	    	logger.error("Error guardar bd.",sql);
	    	throw new Exception("Error guardar bd.",sql);		    	
		}catch(WebServiceException c){
	    	error = "DDA-301";	    	
	    	logger.error("Error Comunicacion web service.",c);
	    	throw new Exception("Error Comunicacion web service.",c);
	    }catch(SoapFaultClientException se){	    	
	    	error = "DDA-302";
	    	logger.error("Error Interno en SAP. ",se);			    			    			    			    			    
	    	throw new Exception("Error Interno en SAP.",se);
	    }catch(Exception e){
	    	error = "DDA-501";	    	
	    	logger.error("Error proceso.",e);
	    	throw new Exception("Error proceso.",e);		    	
	    }finally{	    	
	    	if(!creado){
	    		request = TransformaSAPToDDA.getActivoFijoI20DTO(param, new DTNombreActivoFRes.Respuesta());
	    		request.setEstatusDDA(error);
		    	activoFijoDAO.notificarNuevoTitulo(request);
	    	}	    		    		    	
	    }
    
	    return request;		
	}
	
	/*@See Implementacion interfaz 25 
	 */	
	public ActivoFijoI25DTO trasladarActivoFijo(DTTituloMismoValor param)throws Exception{						
		ActivoFijoI25DTO request = new ActivoFijoI25DTO();
		DTActivoFijoRes response = new DTActivoFijoRes();
		String error = "OK";
		boolean creado = false;
		try{								
			error = VerificarDatosDDA.verificarActivoFijoI25(param);
			
		    //Se llama al servicio web de sap	    				
	    	response = (DTActivoFijoRes) wsLogin.marshalSendAndReceive(this.getWsdl("25"), param);
	    	
	    	//se guarda la peticion
	    	request = TransformaSAPToDDA.getActivoFijoI25DTO(param,response.getRespuesta().get(0));
	    	request.setEstatusDDA(error);
	    	activoFijoDAO.trasladarActivoFijo(request);	    		    		    		    	
	    	creado = true;
		}catch(SQLException sql){			
			error = "DDA-101";	    	
	    	logger.error("Error guardar bd.",sql);
	    	throw new Exception("Error guardar bd.",sql);		    	
		}catch(WebServiceException c){
	    	error = "DDA-301";	    	
	    	logger.error("Error Comunicacion web service.",c);
	    	throw new Exception("Error Comunicacion web service.",c);
	    }catch(SoapFaultClientException se){	    	
	    	error = "DDA-302";
	    	logger.error("Error Interno en SAP. ",se);			    			    			    			    			    
	    	throw new Exception("Error Interno en SAP.",se);
	    }catch(Exception e){
	    	error = "DDA-501";	    	
	    	logger.error("Error proceso.",e);
	    	throw new Exception("Error proceso.",e);		    	
	    }finally{	    	
	    	if(!creado){		    		    
		    	request = TransformaSAPToDDA.getActivoFijoI25DTO(param,new DTActivoFijoRes.Respuesta());
		    	request.setEstatusDDA(error);
		    	activoFijoDAO.trasladarActivoFijo(request);
	    	}
	    }
	    return request;
	}
	
	/*@See Implementacion interfaz 27 
	 */	
	public ActivoFijoI27DTO eliminarActivoFijo(DTTituloPorValor param)throws Exception{				
		ActivoFijoI27DTO request = null;
		DTModificaAFRes response = new DTModificaAFRes();
		String error = "OK";
		boolean creado = false;
		try{			
			error = VerificarDatosDDA.verificarActivoFijoI27(param);
			
		    //Se llama al servicio web de sap	    				
	    	response = (DTModificaAFRes) wsLogin.marshalSendAndReceive(this.getWsdl("27"), param);
	    
		    //se guarda en la base de datos la respuesta 		    		    		    
	    	request = TransformaSAPToDDA.getActivoFijoI27DTO(param, response);
	    	request.setEstatusDDA(error);
	    	activoFijoDAO.eliminarActivoFijo(request);	    		    	
			creado = true;
		}catch(SQLException sql){			
			error = "DDA-101";	    	
	    	logger.error("Error guardar bd.",sql);
	    	throw new Exception("Error guardar bd.",sql);		    	
		}catch(WebServiceException c){
	    	error = "DDA-301";	    	
	    	logger.error("Error Comunicacion web service.",c);
	    	throw new Exception("Error Comunicacion web service.",c);
	    }catch(SoapFaultClientException se){	    	
	    	error = "DDA-302";
	    	logger.error("Error Interno en SAP. ",se);			    			    			    			    			    
	    	throw new Exception("Error Interno en SAP.",se);
	    }catch(Exception e){
	    	error = "DDA-501";	    	
	    	logger.error("Error proceso.",e);
	    	throw new Exception("Error proceso.",e);		    	
	    }finally{	    	
	    	if(!creado){
	    		request = TransformaSAPToDDA.getActivoFijoI27DTO(param, response);
	    		request.setEstatusDDA(error);
		    	activoFijoDAO.eliminarActivoFijo(request);
	    	}
	    }
	    return request;
	}
	
	/*@See Implementacion interfaz 29
	 */	
	public ActivoFijoI29DTO modificarActivoFijo(DTVidaUtil param)throws Exception{				
		ActivoFijoI29DTO request = new ActivoFijoI29DTO();
		DTModificaAFRes response = new DTModificaAFRes();
		String error = "OK";
		boolean creado = false;
		
		try{			
			error = VerificarDatosDDA.verificarActivoFijoI29(param);
			
	        //Se llama al servicio web de sap			
	    	response = (DTModificaAFRes) wsLogin.marshalSendAndReceive(this.getWsdl("29"), param);
	    
		    //se guarda en la base de datos la respuesta 		    		    		    
	    	request = TransformaSAPToDDA.getActivoFijoI29DTO(param, response);
	    	request.setEstatusDDA(error);
	    	activoFijoDAO.modificarActivoFijo(request);
	    	creado = true;
		    	    
		}catch(SQLException sql){			
			error = "DDA-101";	    	
	    	logger.error("Error guardar bd.",sql);
	    	throw new Exception("Error guardar bd.",sql);		    	
		}catch(WebServiceException c){
	    	error = "DDA-301";	    	
	    	logger.error("Error Comunicacion web service.",c);
	    	throw new Exception("Error Comunicacion web service.",c);
	    }catch(SoapFaultClientException se){	    	
	    	error = "DDA-302";
	    	logger.error("Error Interno en SAP. ",se);			    			    			    			    			    
	    	throw new Exception("Error Interno en SAP.",se);
	    }catch(Exception e){
	    	error = "DDA-501";	    	
	    	logger.error("Error proceso.",e);
	    	throw new Exception("Error proceso.",e);		    	
	    }finally{   	
	    	if(!creado){
	    		request = TransformaSAPToDDA.getActivoFijoI29DTO(param, new DTModificaAFRes());
	    		request.setEstatusDDA(error);
		    	activoFijoDAO.modificarActivoFijo(request);
	    	}	    		    	
	    }
	    return request;
	}
	
	/*@See Implementacion interfaz 30 
	 */	
	public ActivoFijoI30DTO bajaConPerdidaActivoFijo(DTBajaConPerdida param)throws Exception{				
		ActivoFijoI30DTO request = new ActivoFijoI30DTO();
		DTModificaAFRes response = new DTModificaAFRes();
		String error = "OK";
		boolean creado = false;
		
		try{			
			error = VerificarDatosDDA.verificarActivoFijoI30(param);
			
		    //Se llama al servicio web de sap	    			    
	    	response = (DTModificaAFRes) wsLogin.marshalSendAndReceive(this.getWsdl("30"), param);
	    
		    //se guarda en la base de datos la respuesta 		    		    		    
	    	request = TransformaSAPToDDA.getActivoFijoI30DTO(param, response);
	    	request.setEstatusDDA(error);
	    	activoFijoDAO.bajaConPerdidaActivoFijo(request);		    		    		  		    		    	    	
		    creado = true;
		}catch(SQLException sql){			
			error = "DDA-101";	    	
	    	logger.error("Error guardar bd.",sql);
	    	throw new Exception("Error guardar bd.",sql);		    	
		}catch(WebServiceException c){
	    	error = "DDA-301";	    	
	    	logger.error("Error Comunicacion web service.",c);
	    	throw new Exception("Error Comunicacion web service.",c);
	    }catch(SoapFaultClientException se){	    	
	    	error = "DDA-302";
	    	logger.error("Error Interno en SAP. ",se);			    			    			    			    			    
	    	throw new Exception("Error Interno en SAP.",se);
	    }catch(Exception e){
	    	error = "DDA-501";	    	
	    	logger.error("Error proceso.",e);
	    	throw new Exception("Error proceso.",e);		    	
	    }finally{	    	
	    	if(!creado){
	    		request = TransformaSAPToDDA.getActivoFijoI30DTO(param, new DTModificaAFRes());
	    		request.setEstatusDDA(error);
		    	activoFijoDAO.bajaConPerdidaActivoFijo(request);
	    	}	    		    	
	    }
	    return request;
	}
		
	/*@See Implementacion interfaz 31 
	 */
	public ActivoFijoI31DTO bajaSinPerdidaActivoFijo(DTBajaSinPerdida param)throws Exception{				
		ActivoFijoI31DTO request = new ActivoFijoI31DTO();
		DTModificaAFRes response = new DTModificaAFRes();
		String error = "OK";
		boolean creado = false;
		try{			
			error = VerificarDatosDDA.verificarActivoFijoI31(param);
			
		    //Se llama al servicio web de sap	    			    
	    	response = (DTModificaAFRes) wsLogin.marshalSendAndReceive(this.getWsdl("31"), param);
	    
		    //se guarda en la base de datos la respuesta 		    		    		    
	    	request = TransformaSAPToDDA.getActivoFijoI31DTO(param,response);
	    	request.setEstatusDDA(error);
	    	activoFijoDAO.bajaSinPerdidaActivoFijo(request);		    		    		  		    		    	    	
		    creado  = true;
		}catch(SQLException sql){			
			error = "DDA-101";	    	
	    	logger.error("Error guardar bd.",sql);
	    	throw new Exception("Error guardar bd.",sql);		    	
		}catch(WebServiceException c){
	    	error = "DDA-301";	    	
	    	logger.error("Error Comunicacion web service.",c);
	    	throw new Exception("Error Comunicacion web service.",c);
	    }catch(SoapFaultClientException se){	    	
	    	error = "DDA-302";
	    	logger.error("Error Interno en SAP. ",se);			    			    			    			    			    
	    	throw new Exception("Error Interno en SAP.",se);
	    }catch(Exception e){
	    	error = "DDA-501";	    	
	    	logger.error("Error proceso.",e);
	    	throw new Exception("Error proceso.",e);		    	
	    }finally{	    	
	    	if(!creado){
	    		request = TransformaSAPToDDA.getActivoFijoI31DTO(param, new DTModificaAFRes());
	    		request.setEstatusDDA(error);
		    	activoFijoDAO.bajaSinPerdidaActivoFijo(request);
	    	}	    		    		    
	    }
	    return request;
	}
			
	public String getWsdl(String numinterface)throws Exception{	    	    
	    String wsdl = env.getProperty("ddaContratoCWS.clientws.wsdlLocation.i"+numinterface);	 	    
	    return wsdl;
	}

}
