package com.mx.dla.dda.contrato.trans;

import java.util.ArrayList;
import java.util.List;

import com.americamovil.dda.enviaactivofijo.DTActivoFijo;
import com.americamovil.dda.enviaactivofijo.DTActivoFijoRes;
import com.americamovil.dda.enviaactivofijo.DTTituloMismoValor;
import com.americamovil.dda.enviacontenido.DTContenido;
import com.americamovil.dda.enviacontenido.DTContenidoRes;
import com.americamovil.dda.enviaentradamercancia.DTEntradaMercancia;
import com.americamovil.dda.enviaentradamercancia.DTEntradaMercanciaRes;
import com.americamovil.dda.enviamodifactivofijo.DTBajaConPerdida;
import com.americamovil.dda.enviamodifactivofijo.DTBajaSinPerdida;
import com.americamovil.dda.enviamodifactivofijo.DTModificaAFRes;
import com.americamovil.dda.enviamodifactivofijo.DTTituloPorValor;
import com.americamovil.dda.enviamodifactivofijo.DTVidaUtil;
import com.americamovil.dda.envianombreactivof.DTNombreActivoFReq;
import com.americamovil.dda.envianombreactivof.DTNombreActivoFRes;
import com.americamovil.dda.enviapedidocompra.DTPedidoCompra;
import com.americamovil.dda.enviapedidocompra.DTPedidoCompraRes;
import com.americamovil.dda.enviapostcapitalizacontenido.DTCapitalizaContenido;
import com.americamovil.dda.enviapostcapitalizacontenido.DTCapitalizaContenidoRes;
import com.mx.dla.dda.contrato.dtos.ActivoFijoI10DTO;
import com.mx.dla.dda.contrato.dtos.ActivoFijoI12DTO;
import com.mx.dla.dda.contrato.dtos.ActivoFijoI19DTO;
import com.mx.dla.dda.contrato.dtos.ActivoFijoI20DTO;
import com.mx.dla.dda.contrato.dtos.ActivoFijoI25DTO;
import com.mx.dla.dda.contrato.dtos.ActivoFijoI27DTO;
import com.mx.dla.dda.contrato.dtos.ActivoFijoI29DTO;
import com.mx.dla.dda.contrato.dtos.ActivoFijoI30DTO;
import com.mx.dla.dda.contrato.dtos.ActivoFijoI31DTO;
import com.mx.dla.dda.contrato.dtos.MercanciaI32DTO;
import com.mx.dla.dda.contrato.dtos.MercanciaI32DetDTO;
import com.mx.dla.dda.contrato.dtos.OrdenCompraDetI8DTO;
import com.mx.dla.dda.contrato.dtos.OrdenCompraI8DTO;

public class TransformaSAPToDDA {

	public static OrdenCompraI8DTO getOrdenCompra(DTPedidoCompra param, DTPedidoCompraRes response){
		
			OrdenCompraI8DTO request = new OrdenCompraI8DTO();
								
			if(param.getPedidoCompra().getHSociedad() != null)
				request.sethSociedad(param.getPedidoCompra().getHSociedad());
			
			if(param.getPedidoCompra().getHClaseDoc() != null)
				request.sethClaseDoc(param.getPedidoCompra().getHClaseDoc());
			
			if(param.getPedidoCompra().getHIDProveedor() != null)
				request.setHidProveedor(param.getPedidoCompra().getHIDProveedor());
			
			if(param.getPedidoCompra().getHOrgCompras() != null)
				request.sethOrgCompras(param.getPedidoCompra().getHOrgCompras());
			
			if(param.getPedidoCompra().getHGrupoCompras() != null)
				request.sethGrupoCompras(param.getPedidoCompra().getHGrupoCompras());
			
			if(param.getPedidoCompra().getHFechaDoc() != null)
				request.sethFechaDoc(param.getPedidoCompra().getHFechaDoc());
			
			if(param.getPedidoCompra().getHReferencia() != null)
				request.sethReferencia(param.getPedidoCompra().getHReferencia()); 			
									
			List<OrdenCompraDetI8DTO> items = new ArrayList<OrdenCompraDetI8DTO>();
			
			for(DTPedidoCompra.PedidoCompra.Item item : param.getPedidoCompra().getItem()){
				
				OrdenCompraDetI8DTO newItem = new OrdenCompraDetI8DTO();
				
				if(item.getIIDPosicion() != null)
					newItem.setIidPosicion(item.getIIDPosicion());
				
				if(item.getIIDMaterial() != null)
					newItem.setIidMaterial(item.getIIDMaterial());
				
				if(item.getICentro() != null)
					newItem.setiCentro(item.getICentro());
				
				if(item.getICantidad() != null)
					newItem.setiCantidad(item.getICantidad());
				
				if(item.getIPrecio() != null)
					newItem.setiPrecio(item.getIPrecio());
				
				if(item.getIIndicadorIVA() != null)
					newItem.setiIndicadorIVA(item.getIIndicadorIVA());
				
				if(item.getITipoImputacion() != null)
					newItem.setiTipoImputacion(item.getITipoImputacion());
				
				if(item.getIIDPosicionAcc() != null)
					newItem.setIidPosicionAcc(item.getIIDPosicionAcc()); 								
				
				if(item.getICentroCoste() != null)
					newItem.setiCentroCoste(item.getICentroCoste());
				
				if(item.getIIDOrden() != null)
					newItem.setIidOrden(item.getIIDOrden());
				
				items.add(newItem);
			}
			
			//Se valida respuesta
			if(response.getResultado() != null && response.getResultado().getPONumber() != null)
				request.setPoNumber(verificarLongitud(response.getResultado().getPONumber(), 25));
			
			if(response.getResultado() != null && response.getResultado().getIDMensaje() != null)
				request.setIdMensaje(verificarLongitud(response.getResultado().getIDMensaje(), 10));
			
			if(response.getResultado() != null && response.getResultado().getDescripcion() != null)
				request.setDescripcion(verificarLongitud(response.getResultado().getDescripcion(), 100));

			request.setItem(items); 												
			
			return request;
	}

	public static ActivoFijoI10DTO getActivoFijoI10DTO(DTActivoFijo.Registro param, DTActivoFijoRes.Respuesta response){
		
		ActivoFijoI10DTO dto = new ActivoFijoI10DTO();
		
		if(param.getOrdenCompra() != null)
			dto.setOrdenCompra(param.getOrdenCompra());
		
		if(param.getProveedor() != null)
			dto.setProveedor(param.getProveedor());
		
		if(param.getDescripcion() != null)
			dto.setDescripcion(param.getDescripcion());
		
		if(param.getCodigoDDA() != null)
			dto.setCodigoDDA(param.getCodigoDDA());
		
		if(param.getCentroCoste() != null)
			dto.setCentroCoste(param.getCentroCoste());
		
		if(response.getExcepcion() != null)
			dto.setrExcepcion(verificarLongitud(response.getExcepcion(), 150));
		
		if(response.getIDSAP() != null)
			dto.setrIdSap(verificarLongitud(response.getIDSAP(), 25));
		
		if(response.getIDDDA() != null)
			dto.setrIsSap(verificarLongitud(response.getIDDDA(), 25));
		
		return dto;
	}

	public static ActivoFijoI12DTO getActivoFijoI12DTO(DTContenido.Registro param, DTContenidoRes.Respuesta response){
		
		   ActivoFijoI12DTO item = new ActivoFijoI12DTO();
		   
		   if(param.getCodigoSAP() != null)
			   item.setCodigoSAP(param.getCodigoSAP());
		   
		   if(param.getValor() != null)
			   item.setValor(param.getValor());
		   
		   if(param.getFechaInicio() != null)
			   item.setFechaInicio(param.getFechaInicio());
		   
		   if(param.getVU() != null)
			   item.setVu(param.getVU());
		   		   
		   if(response.getCodigoDDA() != null)
			   item.setrCodigoDDA(verificarLongitud(response.getCodigoDDA(), 25));
		   
		   if(response.getMensaje() != null)			   
			   item.setrMensaje(verificarLongitud(response.getMensaje(), 150));
		   
		   if(response.getStatus() != null)
			   item.setrEstatus(verificarLongitud(response.getStatus(), 25));
		   
		   return item;		
	}
	
	public static ActivoFijoI19DTO getActivoFijoI19DTO(DTCapitalizaContenido.Registro param, DTCapitalizaContenidoRes.Respuesta response){
		
		ActivoFijoI19DTO item = new ActivoFijoI19DTO();
		
		if(param.getCodigoSAP() != null)
			item.setCodigoSAP(param.getCodigoSAP());
		
		if(param.getAumentoValor() != null)
			item.setAumentoValor(param.getAumentoValor());
		
		if(param.getFechaInicio() != null)
			item.setFechaInicio(param.getFechaInicio());				

		if(response.getStatus() != null)
			item.setrStatus(verificarLongitud(response.getStatus(), 150));
		
		return item;		
	}
	
	public static ActivoFijoI20DTO getActivoFijoI20DTO(DTNombreActivoFReq param, DTNombreActivoFRes.Respuesta response){
		
		ActivoFijoI20DTO item = new ActivoFijoI20DTO();
		
		if(param.getRegistro() != null && param.getRegistro().getIDActivoFSAP() != null)
			item.setCodigoSap(param.getRegistro().getIDActivoFSAP());		
		
		if(param.getRegistro() != null && param.getRegistro().getNuevoNombre() != null)
			item.setNuevoNombre(param.getRegistro().getNuevoNombre());		
		
		if(response.getStatus() != null)
			item.setrEstatus(verificarLongitud(response.getStatus(), 150));
		return item;		
	}
	
	public static ActivoFijoI25DTO getActivoFijoI25DTO(DTTituloMismoValor param, DTActivoFijoRes.Respuesta response){
		
		ActivoFijoI25DTO item = new ActivoFijoI25DTO();
		
		if(param.getCodigoDDANuevo() != null)
			item.setCodigoDDANuevo(param.getCodigoDDANuevo());
		
		if(param.getCodigoSAPAnt() != null)
			item.setCodigoSAPAnt(param.getCodigoSAPAnt());
		
		if(param.getDescActNuevo() != null)
			item.setDescActNuevo(param.getDescActNuevo());
				
		
		if(response.getExcepcion() != null)
			item.setrException(verificarLongitud(response.getExcepcion(), 100));
		
		if(response.getIDDDA() != null)
			item.setrIdDda(verificarLongitud(response.getIDDDA(), 25));
		
		if(response.getIDSAP() != null)
			item.setrIdSap(verificarLongitud(response.getIDSAP(), 25));
		
		return item;		
	}

	public static ActivoFijoI27DTO getActivoFijoI27DTO(DTTituloPorValor param, DTModificaAFRes response){
		
		ActivoFijoI27DTO item = new ActivoFijoI27DTO();
		
		if(param.getCodigoSAPAnt() != null)
			item.setCodigoSap(param.getCodigoSAPAnt());
		
		
		if(response.getStatus() != null)
			item.setrEstatus(verificarLongitud(response.getStatus(), 150));
		return item;
	}
	
	public static ActivoFijoI29DTO getActivoFijoI29DTO(DTVidaUtil param, DTModificaAFRes response){
		
		ActivoFijoI29DTO item = new ActivoFijoI29DTO();
		
		if(param.getCodigoSAP() != null)
			item.setCodigoSap(param.getCodigoSAP());
		
		if(param.getFechaInicio() != null)
			item.setFechaInicio(param.getFechaInicio());
		
		if(param.getVU() != null)
			item.setVu(param.getVU());	
		
		if(response.getStatus() != null)
			item.setrStatus(verificarLongitud(response.getStatus(), 150));
		return item;
	}

	public static ActivoFijoI30DTO getActivoFijoI30DTO(DTBajaConPerdida param, DTModificaAFRes response){
	
		ActivoFijoI30DTO item = new ActivoFijoI30DTO();
	
		if(param.getCodigoSAP() != null)
			item.setCodigoSAP(param.getCodigoSAP());
	
		
		if(response.getStatus() != null)
			item.setrEstatus(verificarLongitud(response.getStatus(), 150));
		return item;
	}
	
	public static ActivoFijoI31DTO getActivoFijoI31DTO(DTBajaSinPerdida param, DTModificaAFRes response){
		
		ActivoFijoI31DTO item = new ActivoFijoI31DTO();
		
		if(param.getCodigoSAP() != null)
			item.setCodigoSAP(param.getCodigoSAP());
		
		
		if(response.getStatus() != null)
			item.setrEstatus(verificarLongitud(response.getStatus(), 150));
		return item;
	}
	
	public static MercanciaI32DTO getMercanciaI32DTO(DTEntradaMercancia param, DTEntradaMercanciaRes response){
		
		MercanciaI32DTO item = new MercanciaI32DTO();
		
		if(param.getFechaContab() != null)
			item.setFechaContabilidad(param.getFechaContab());
		
		if(param.getFechaDoc() != null)
			item.setFechaDocto(param.getFechaDoc());
		
		if(param.getNumeroPO() != null)
			item.setNumeroPo(param.getNumeroPO());
		
		if(param.getTextoCab() != null)
			item.setTexto(param.getTextoCab());
		
		if(param.getActividad() != null)
			item.setActividad(param.getActividad());	
        
        if(response.getRespuesta() != null && response.getRespuesta().getDocMaterial() != null)
        	item.setrDocMaterial(verificarLongitud(response.getRespuesta().getDocMaterial(), 25));
        
        if(response.getRespuesta() != null && response.getRespuesta().getEjercDoc() != null)
        	item.setrEjerDoc(verificarLongitud(response.getRespuesta().getEjercDoc(), 10));
        
        if(response.getRespuesta() != null && response.getRespuesta().getMensaje() != null)
        	item.setrMensaje(verificarLongitud(response.getRespuesta().getMensaje(), 150));
		
		List<MercanciaI32DetDTO> items = new ArrayList<MercanciaI32DetDTO>();
		
		for(DTEntradaMercancia.Item itemIn : param.getItem()){
			
			MercanciaI32DetDTO it = new MercanciaI32DetDTO();
			
			if(itemIn.getCentro() != null)
				it.setCentro(itemIn.getCentro());
			
			if(itemIn.getClaseMov() != null)
				it.setMovimiento(itemIn.getClaseMov());
			
			if(itemIn.getCantidad() != null)
				it.setCantidad(itemIn.getCantidad());
			
			if(itemIn.getNumeroPO() != null)
				it.setNumeroPo(itemIn.getNumeroPO());
			
			if(itemIn.getPosicionRefPO() != null)
				it.setPosicionRef(itemIn.getPosicionRefPO());
			
			if(itemIn.getIndicadorMvto() != null)
				it.setIndicadorMov(itemIn.getIndicadorMvto());
			
			items.add(it);
		}		
		item.setItem(items);
		
		return item;
	}
	
	public static String verificarLongitud(String str, int tamano){		   
		   if(str == null)
			   return "";
	       else if(str.length() > tamano)
			    return str.substring(0,tamano);		   
		   else
			   return str;
	}
}

