package com.mx.dla.dda.contrato.pedido.bos;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.contrato.pedido.daos.PedidoDAO;
import com.mx.dla.dda.contrato.pedido.dtos.AgregarPedidoDTO;
import com.mx.dla.dda.contrato.pedido.dtos.ContratoMaterialDTO;
import com.mx.dla.dda.contrato.pedido.dtos.ModificarPedidoDTO;
import com.mx.dla.dda.contrato.pedido.dtos.NotificarPedidoDTO;
import com.mx.dla.dda.contrato.pedido.exception.PedidoException;
import com.mx.dla.dda.contrato.pedido.generales.dtos.RespuestaDTO;
import com.mx.dla.dda.contrato.pedido.tranform.TransformaSAPtoDDA;
import com.mx.dla.dda.utilerias.BeanUtilerias;

public class PedidoBO {
	private static Logger      log       = Logger.getLogger(PedidoBO.class);

	@Autowired
	private PedidoDAO          pedidoDAO;

	private TransformaSAPtoDDA transform = new TransformaSAPtoDDA();

	/**
	 * 
	 * @param List
	 *            <RespuestaDTO> parametro "lista de parametros
	 * @return List<RespuestaDTO> lista de respuestas
	 */
	public RespuestaDTO agregarPedido(List<AgregarPedidoDTO> parametro) {

		RespuestaDTO respuesta = null;
		boolean valido = true;
		List<ContratoMaterialDTO> requests = new ArrayList<ContratoMaterialDTO>();
		String ordenCompra = null;

		try {

			for (AgregarPedidoDTO material : parametro) {

				ContratoMaterialDTO contratoMaterialDestino = null;
				ContratoMaterialDTO contratoMaterialOrigen = null;
				ContratoMaterialDTO contratoMaterialAuxiliar = null;
				// List<ContratoMaterialDTO> contratosMaterialAuxiliar = null;
				LinkedList<ContratoMaterialDTO> contratosMaterialAuxiliar = null;

				Long licencia = null;

				BeanUtilerias.trimStrings(material);

				ordenCompra = material.getOrdenCompra();

				log.info("    <<<< Datos del pedido >>>");
				// log.info(material);
				log.info("     Inicio de la validacion del pedido: " + material);

				respuesta = verificar(material);

				if (!respuesta.getEstatus().equals("OK"))
					throw new PedidoException(respuesta.getDescripcion());

				contratoMaterialDestino = transform.transformaContratoMaterial(material);

				contratosMaterialAuxiliar = new LinkedList<ContratoMaterialDTO>(pedidoDAO.buscaContratoMaterial(contratoMaterialDestino));

				if (contratosMaterialAuxiliar != null && !contratosMaterialAuxiliar.isEmpty())
					if (contratosMaterialAuxiliar.size() > 1)
						throw new PedidoException("La orden de compra " + ordenCompra + " tiene mas de un registro con los datos proporcionados a actualizar");
					else
						contratoMaterialOrigen = contratosMaterialAuxiliar.getFirst();
				else
					contratoMaterialOrigen = new ContratoMaterialDTO();

				if (!StringUtils.isNumeric(material.getLicencia()))
					throw new PedidoException("La licencia proporcionada no es un numero valido: " + material.getLicencia());

				licencia = Long.parseLong(material.getLicencia());

				contratoMaterialAuxiliar = pedidoDAO.buscaIdContrato(licencia);

				if (contratoMaterialAuxiliar == null || contratoMaterialAuxiliar.getIdContratoOrig() == null)
					throw new PedidoException("No se encontro contrato para la licencia: " + licencia);

				Long idContratoOriginal = contratoMaterialAuxiliar.getIdContratoOrig();
				contratoMaterialDestino.setIdContratoOrig(idContratoOriginal);

				contratoMaterialAuxiliar = pedidoDAO.buscaIdMaterial(material.getCodigoMaterial());

				if (contratoMaterialAuxiliar == null || contratoMaterialAuxiliar.getIdMaterial() == null)
					throw new PedidoException("No se encontro material para codigo de material: " + material.getCodigoMaterial());

				contratoMaterialDestino.setIdMaterial(contratoMaterialAuxiliar.getIdMaterial());

				contratoMaterialAuxiliar = pedidoDAO.buscaTituloOriginal(licencia);

				if (contratoMaterialAuxiliar == null || contratoMaterialAuxiliar.getLicencia() == null)
					throw new PedidoException("No se encontro informacion de titulo con la licencia: " + licencia);

				contratoMaterialDestino.setTitulo(contratoMaterialAuxiliar.getTitulo());
				contratoMaterialDestino.setLicencia(contratoMaterialAuxiliar.getLicencia());

				contratoMaterialDestino = BeanUtilerias.mergeNotNullProperties(contratoMaterialOrigen, contratoMaterialDestino, new String[] {}, ContratoMaterialDTO.class);

				requests.add(contratoMaterialDestino);

				// log.info(contratoMaterialDestino);
				log.info("    Fin de la validacion del pedido:" + ordenCompra + " con resultado: " + respuesta.getEstatus() + " - " + respuesta.getDescripcion());

			}

		}
		catch (Exception e) {
			respuesta.setDescripcion(e.getMessage());
			respuesta.setEstatus("ERROR");
			log.info("    Fin de la validacion del pedido: " + ordenCompra + " con resultado: " + respuesta.getEstatus() + " - " + respuesta.getDescripcion());

			valido = false;
		}

		if (valido) {

			Long registro = 0L;

			try {

				log.info("    Inicia persistencia   ");

				for (ContratoMaterialDTO request : requests) {

					log.info("      Registro " + registro + " : " + request);

					ordenCompra = request.getOrdenCompra();

					// log.info("   Inicia persistencia del pedido: " + ordenCompra);

					// List<ContratoMaterialDTO> consultaAuxiliar = pedidoDAO.buscaContratoMaterial(request);
					// if (consultaAuxiliar != null && !consultaAuxiliar.isEmpty())
					if (request.getIdCntMaterial() != null)
						pedidoDAO.actualizaContratoMaterial(request);
					else
						pedidoDAO.creaContratoMaterial(request);

					registro++;

					// log.info("    Fin persistencia del pedido: " + ordenCompra + " con resultado: " +
					// respuesta.getEstatus() + " - " + respuesta.getDescripcion());

				}

				log.info("    Fin persistencia con resultado: " + respuesta.getEstatus() + " - " + respuesta.getDescripcion());

			}
			catch (Exception e) {
				respuesta.setDescripcion(e.getMessage());
				respuesta.setEstatus("ERROR");
				// log.info("    Fin persistencia del pedido: " + ordenCompra + " con resultado: " +
				// respuesta.getEstatus() + " - " + respuesta.getDescripcion());
				log.info("    Fin persistencia con resultado: " + respuesta.getEstatus() + " en pedido " + ordenCompra + " *** " + respuesta.getDescripcion() + " *** ");

			}
		}

		return respuesta;

	}

	public RespuestaDTO modificarPedido(List<ModificarPedidoDTO> parametro) {

		RespuestaDTO respuesta = null;
		boolean valido = true;
		List<ContratoMaterialDTO> requests = new ArrayList<ContratoMaterialDTO>();
		String ordenCompra = null;

		try {

			for (ModificarPedidoDTO material : parametro) {

				ContratoMaterialDTO contratoMaterialDestino = null;
				ContratoMaterialDTO contratoMaterialOrigen = null;
				ContratoMaterialDTO contratoMaterialAuxiliar = null;
				// List<ContratoMaterialDTO> contratosMaterialAuxiliar = null;
				LinkedList<ContratoMaterialDTO> contratosMaterialAuxiliar = null;

				Long licencia = null;

				BeanUtilerias.trimStrings(material);

				ordenCompra = material.getOrdenCompra();

				log.info("    <<<< Datos del pedido >>>");
				log.info("     Inicio de la validacion del pedido: " + material);

				respuesta = verificar(material);

				if (!respuesta.getEstatus().equals("OK"))
					throw new PedidoException(respuesta.getDescripcion());

				contratoMaterialDestino = transform.transformaContratoMaterial(material);

				contratosMaterialAuxiliar = new LinkedList<ContratoMaterialDTO>(pedidoDAO.buscaContratoMaterial(contratoMaterialDestino));

				if (contratosMaterialAuxiliar != null && !contratosMaterialAuxiliar.isEmpty())
					if (contratosMaterialAuxiliar.size() > 1)
						throw new PedidoException("La orden de compra " + ordenCompra + " tiene mas de un registro con los datos proporcionados a actualizar");
					else
						contratoMaterialOrigen = contratosMaterialAuxiliar.getFirst();
				else
					contratoMaterialOrigen = new ContratoMaterialDTO();
				// throw new PedidoException("La orden de compra " + ordenCompra +
				// " no tiene registro con los datos proporcionados a actualizar");

				if (!StringUtils.isNumeric(material.getLicencia()))
					throw new PedidoException("La licencia proporcionada no es un numero valido: " + material.getLicencia());

				licencia = Long.parseLong(material.getLicencia());

				contratoMaterialAuxiliar = pedidoDAO.buscaIdContrato(licencia);

				if (contratoMaterialAuxiliar == null || contratoMaterialAuxiliar.getIdContratoOrig() == null)
					throw new PedidoException("No se encontr contrato para la licencia: " + licencia);

				Long idContratoOriginal = contratoMaterialAuxiliar.getIdContratoOrig();
				contratoMaterialDestino.setIdContratoOrig(idContratoOriginal);

				contratoMaterialAuxiliar = pedidoDAO.buscaIdMaterial(material.getCodigoMaterial());

				if (contratoMaterialAuxiliar == null || contratoMaterialAuxiliar.getIdMaterial() == null)
					throw new PedidoException("No se encontro material para codigo de material: " + material.getCodigoMaterial());

				contratoMaterialDestino.setIdMaterial(contratoMaterialAuxiliar.getIdMaterial());

				contratoMaterialAuxiliar = pedidoDAO.buscaTituloOriginal(licencia);

				if (contratoMaterialAuxiliar == null || contratoMaterialAuxiliar.getLicencia() == null)
					throw new PedidoException("No se encontro informacion de titulo con la licencia: " + licencia);

				contratoMaterialDestino.setTitulo(contratoMaterialAuxiliar.getTitulo());
				contratoMaterialDestino.setLicencia(contratoMaterialAuxiliar.getLicencia());

				contratoMaterialDestino = BeanUtilerias.mergeNotNullProperties(contratoMaterialOrigen, contratoMaterialDestino, new String[] { "indicadorEf", "indicadorFf" },
				        ContratoMaterialDTO.class); 

				requests.add(contratoMaterialDestino);

				log.info(contratoMaterialDestino);
				log.info("    Fin de la validacion del pedido:" + ordenCompra + " con resultado: " + respuesta.getEstatus() + " - " + respuesta.getDescripcion());

			}

		}
		catch (Exception e) {
			respuesta.setDescripcion(e.getMessage());
			respuesta.setEstatus("ERROR");
			log.info("     Fin de la validacion del pedido: " + ordenCompra + " con resultado: " + respuesta.getEstatus() + " - " + respuesta.getDescripcion());

			valido = false;
		}

		if (valido) {

			Long registro = 0L;

			try {

				log.info("    Inicia persistencia   ");

				for (ContratoMaterialDTO request : requests) {

					log.info("      Registro " + registro + " : " + request);

					ordenCompra = request.getOrdenCompra();

					// log.info("     Inicia persistencia del pedido: " + ordenCompra);

					if (request.getIdCntMaterial() != null)
						pedidoDAO.actualizaContratoMaterial(request);
					else
						pedidoDAO.creaContratoMaterial(request);

					registro++;

					// log.info("     Fin persistencia del pedido: " + ordenCompra + " con resultado: " +
					// respuesta.getEstatus() + " - " + respuesta.getDescripcion());

				}

				log.info("    Fin persistencia con resultado: " + respuesta.getEstatus() + " - " + respuesta.getDescripcion());

			}
			catch (Exception e) {
				respuesta.setDescripcion(e.getMessage());
				respuesta.setEstatus("ERROR");
				// log.info("     Fin persistencia del pedido: " + ordenCompra + " con resultado: " +
				// respuesta.getEstatus() + " - " + respuesta.getDescripcion());
				log.info("    Fin persistencia con resultado: " + respuesta.getEstatus() + " en pedido " + ordenCompra + " *** " + respuesta.getDescripcion() + " *** ");

			}
		}

		return respuesta;
	}

	public RespuestaDTO notificarEntrada(List<NotificarPedidoDTO> parametro) {

		RespuestaDTO respuesta = null;
		boolean valido = true;
		List<ContratoMaterialDTO> requests = new ArrayList<ContratoMaterialDTO>();
		String ordenCompra = null;

		try {

			for (NotificarPedidoDTO material : parametro) {

				ContratoMaterialDTO contratoMaterialDestino = null;
				ContratoMaterialDTO contratoMaterialOrigen = null;
				ContratoMaterialDTO contratoMaterialAuxiliar = null;
				// List<ContratoMaterialDTO> contratosMaterialAuxiliar = null;
				LinkedList<ContratoMaterialDTO> contratosMaterialAuxiliar = null;

				BeanUtilerias.trimStrings(material);

				ordenCompra = material.getOrdenCompra();

				log.info("    <<<< Datos del pedido >>>");
				log.info(material);
				log.info("    Inicio de la validacion del pedido: " + ordenCompra);

				respuesta = verificar(material);

				if (!respuesta.getEstatus().equals("OK"))
					throw new PedidoException(respuesta.getDescripcion());

				contratoMaterialDestino = transform.transformaContratoMaterial(material);

				contratosMaterialAuxiliar = new LinkedList<ContratoMaterialDTO>(pedidoDAO.buscaContratoMaterial(contratoMaterialDestino));

				if (contratosMaterialAuxiliar != null && !contratosMaterialAuxiliar.isEmpty())
					if (contratosMaterialAuxiliar.size() > 1)
						throw new PedidoException("La orden de compra " + ordenCompra + " tiene mas de un registro con los datos proporcionados a actualizar");
					else
						contratoMaterialOrigen = contratosMaterialAuxiliar.getFirst();
				else
					throw new PedidoException("La orden de compra " + ordenCompra + " no tiene registro con los datos proporcionados a actualizar");

				contratoMaterialAuxiliar = pedidoDAO.buscaIdMaterial(material.getCodigoMaterial());

				if (contratoMaterialAuxiliar == null || contratoMaterialAuxiliar.getIdMaterial() == null)
					throw new PedidoException("No se encontro material para codigo de material: " + material.getCodigoMaterial());

				contratoMaterialDestino.setIdMaterial(contratoMaterialAuxiliar.getIdMaterial());

				contratoMaterialDestino = BeanUtilerias.mergeNotNullProperties(contratoMaterialOrigen, contratoMaterialDestino, new String[] {}, ContratoMaterialDTO.class);

				requests.add(contratoMaterialDestino);

				log.info(contratoMaterialDestino);
				log.info("    Fin de la validacion del pedido:" + ordenCompra + " con resultado: " + respuesta.getEstatus() + " - " + respuesta.getDescripcion());

			}

		}
		catch (Exception e) {
			respuesta.setDescripcion(e.getMessage());
			respuesta.setEstatus("ERROR");
			log.info("    Fin de la validacion del pedido: " + ordenCompra + " con resultado: " + respuesta.getEstatus() + " - " + respuesta.getDescripcion());

			valido = false;
		}

		if (valido) {
			try {
				for (ContratoMaterialDTO request : requests) {

					ordenCompra = request.getOrdenCompra();

					log.info("   Inicia persistencia del pedido: " + ordenCompra);

					// List<ContratoMaterialDTO> consultaAuxiliar = pedidoDAO.buscaContratoMaterial(request);

					// if (consultaAuxiliar != null && !consultaAuxiliar.isEmpty())
					pedidoDAO.actualizaContratoMaterial(request);

					log.info("    Fin persistencia del pedido: " + ordenCompra + " con resultado: " + respuesta.getEstatus() + " - " + respuesta.getDescripcion());
				}
			}
			catch (Exception e) {
				respuesta.setDescripcion(e.getMessage());
				respuesta.setEstatus("ERROR");
				log.info("    Fin persistencia del pedido: " + ordenCompra + " con resultado: " + respuesta.getEstatus() + " - " + respuesta.getDescripcion());
			}
		}

		return respuesta;

	}

	/*	public RespuestaDTO notificarEntrada(List<NotificarPedidoDTO> parametro) {

			// List<RespuestaDTO> respuestas = new ArrayList<RespuestaDTO>();
			RespuestaDTO respuesta = null;
			PedidoI39DTO notificar = new PedidoI39DTO();
			boolean valido = true;

			for (NotificarPedidoDTO material : parametro) {
				try {

					log.info("    <<<< Datos del material pedido >>>");
					log.info(material.toString());

					log.info("    Inicio de la validacion del material pedido:" + material.getCodigoMaterial());
					respuesta = verificar(material);
					log.info("    Fin de la validacion del material pedido:" + material.getCodigoMaterial() + " con resultado: " + respuesta.getEstatus());

					if (!respuesta.getEstatus().equals("OK")) {
						valido = false;
						log.info("Detalle de error: " + respuesta.getDescripcion());
						respuesta.setEstatus("ERROR");
						break;
					}
				}
				catch (Exception e) {
					log.error(e);
				}
			}

			for (NotificarPedidoDTO material : parametro) {

				try {

					// respuesta = verificarI39(material);
					if (valido) {
						notificar = transform.tranformaNotificarPedioToPedidoI39(material, respuesta);
						pedidoDAO.notificarEntrada(notificar);
					}

				}
				catch (Exception e) { // | DataIntegrityViolationException cacha
					                  // cuando un tipo de dato excede el tamano
					log.error(e);
					respuesta.setEstatus("DDA-501");
					respuesta.setDescripcion("Error inesperado");
					log.error(respuesta.getDescripcion());
				}

				// respuestas.add(respuesta);
			}

			return respuesta;

		}

		public RespuestaDTO modificarPedido(List<ModificarPedidoDTO> parametro) {

			// List<RespuestaDTO> respuestas = new ArrayList<RespuestaDTO>();
			RespuestaDTO respuesta = null;
			PedidoI43DTO update = new PedidoI43DTO();
			boolean valido = true;

			for (ModificarPedidoDTO material : parametro) {
				log.info("    <<<< Datos del material pedido >>>");
				log.info(material.toString());

				log.info("    Inicio de la validacion del material pedido:" + material.getCodigoMaterial());
				respuesta = verificar(material);
				log.info("    Fin de la validacion del material pedido:" + material.getCodigoMaterial() + " con resultado: " + respuesta.getEstatus());

				if (!respuesta.getEstatus().equals("OK")) {
					valido = false;
					log.info("Detalle de error: " + respuesta.getDescripcion());
					respuesta.setEstatus("ERROR");
					break;
				}
			}

			for (ModificarPedidoDTO material : parametro) {

				if (valido) {
					try {

						// respuesta = verificarI43(material);
						update = transform.tranformaModificarPedioToPedidoI43(material, respuesta);

						update.setEstatus(respuesta.getEstatus());
						update.setDescripcion(respuesta.getDescripcion());

						pedidoDAO.modificarPedido(update);

					}
					catch (Exception e) { // | DataIntegrityViolationException cacha
						                  // cuando un tipo de dato excede el tamaño
						log.error("Error Inesperado." + e);

						respuesta.setEstatus("DDA-501");
						respuesta.setDescripcion("Error inesperado");
					}
				}

				// respuestas.add(respuesta);
			}

			return respuesta;

		}*/

	/**
	 * INTERFAZ 37
	 * 
	 * @param material
	 *            pedido que va a verificar que esten todos sus datos y que no sobrepasen el tamano en la base
	 * @return RespuestaDTO regresa un objeto respuesta que contiene los campos estatus y descripcion
	 */
	public RespuestaDTO verificar(AgregarPedidoDTO material) {

		RespuestaDTO respuesta = new RespuestaDTO();
		respuesta.setEstatus("OK");
		respuesta.setDescripcion("Datos registrados correctamente en DDA");

		if (material.getOrdenCompra() == null || material.getOrdenCompra().equals("")) {
			respuesta.setEstatus("DDA-201");
			respuesta.setDescripcion("Falta informacion en [orden compra]");
		}
		else if (material.getOrdenCompra().length() > 10) {
			respuesta.setEstatus("DDA-202");
			respuesta.setDescripcion("El parametro [orden compra] excede tamanio (10)");
		}

		if (material.getPosicion() == null || material.getPosicion().equals("")) {
			respuesta.setEstatus("DDA-201 ");
			respuesta.setDescripcion("Falta informacion en parametros [posicion]");
		}
		else if (material.getPosicion().length() > 5) {
			respuesta.setEstatus("DDA-202");
			respuesta.setDescripcion("El parametro [posicion] excede tamano (5)");
		}

		if (material.getCodigoMaterial() == null || material.getCodigoMaterial().equals("")) {
			respuesta.setEstatus("DDA-201 ");
			respuesta.setDescripcion("Falta informacion en parametros [codigoMaterial]");
		}
		else if (material.getCodigoMaterial().length() > 18) {
			respuesta.setEstatus("DDA-202");
			respuesta.setDescripcion("El parametro [codigoMaterial] excede tamano (18)");
		}

		if (material.getImporte() == null || material.getImporte().equals("")) {
			respuesta.setEstatus("DDA-201 ");
			respuesta.setDescripcion("Falta informacion en parametros [importe]");
		}
		else if (!verificarNumero(material.getImporte()) || material.getImporte().length() > 17) {
			respuesta.setEstatus("DDA-202");
			respuesta.setDescripcion("El parametro [importe] no es un numero valido o excede tamano (17)");
		}

		if (material.getLicencia() == null || material.getLicencia().equals("")) {
			respuesta.setEstatus("DDA-201 ");
			respuesta.setDescripcion("Falta informacion en parametros [licencia]");
		}
		else if (material.getLicencia().length() > 12) {
			respuesta.setEstatus("DDA-202");
			respuesta.setDescripcion("El parametro [licencia] excede tamano (12)");
		}

		return respuesta;

	}

	/**
	 * INTERFAZ 39
	 * 
	 * @param material
	 *            pedido que va a verificar que esten todos sus datos y que no sobrepasen el tamano en la base
	 * @return RespuestaDTO regresa un objeto respuesta que contiene los campos estatus y descripcion
	 */
	public RespuestaDTO verificar(NotificarPedidoDTO material) {

		RespuestaDTO respuesta = new RespuestaDTO();
		respuesta.setEstatus("OK");
		respuesta.setDescripcion("Datos registrados correctamente en DDA");

		if (material.getCodigoMaterial() == null || material.getCodigoMaterial().equals("")) {
			respuesta.setEstatus("DDA-201 ");
			respuesta.setDescripcion("Falta informacion en parametros [codigoMaterial]");
		}
		else if (material.getCodigoMaterial().length() > 18) {
			respuesta.setEstatus("DDA-202");
			respuesta.setDescripcion("El parametro [codigoMaterial] excede tamano (18)");
		}

		if (material.getEjercicio() == null || material.getEjercicio().equals("")) {
			respuesta.setEstatus("DDA-201 ");
			respuesta.setDescripcion("Falta informacion en parametros [ejercicio]");
		}
		else if (material.getEjercicio().length() > 4) {
			respuesta.setEstatus("DDA-202");
			respuesta.setDescripcion("El parametro [ejercicio] excede tamano (4)");
		}

		if (material.getPosicion() == null || material.getPosicion().equals("")) {
			respuesta.setEstatus("DDA-201 ");
			respuesta.setDescripcion("Falta informacion en parametros [posicion]");
		}
		else if (material.getPosicion().length() > 5) {
			respuesta.setEstatus("DDA-202");
			respuesta.setDescripcion("El parametro [posicion] excede tamano (5)");
		}

		if (material.getPosicionPO() == null || material.getPosicionPO().equals("")) {
			respuesta.setEstatus("DDA-201 ");
			respuesta.setDescripcion("Falta informacion en parametros [posicionPO]");
		}
		else if (material.getPosicionPO().length() > 5) {
			respuesta.setEstatus("DDA-202");
			respuesta.setDescripcion("El parametro [posicionPO] excede tamano (5)");
		}

		if (material.getMaterial() == null || material.getMaterial().equals("")) {
			respuesta.setEstatus("DDA-201 ");
			respuesta.setDescripcion("Falta informacion en parametros [material]");
		}
		else if (material.getMaterial().length() > 10) {
			respuesta.setEstatus("DDA-202");
			respuesta.setDescripcion("El parametro [material] excede tamano (10)");
		}

		if (material.getImporte() == null || material.getImporte().equals("")) {
			respuesta.setEstatus("DDA-201 ");
			respuesta.setDescripcion("Falta informacion en parametros [importe]");
		}
		else if (!verificarNumero(material.getImporte()) || material.getImporte().length() > 17) {
			respuesta.setEstatus("DDA-202");
			respuesta.setDescripcion("El parametro [importe] no es un numero valido o excede tamano (17)");
		}

		if (material.getMovimiento() == null || material.getMovimiento().equals("")) {
			respuesta.setEstatus("DDA-201 ");
			respuesta.setDescripcion("Falta informacion en parametros [movimiento]");
		}
		else if (material.getMovimiento().length() > 3) {
			respuesta.setEstatus("DDA-202");
			respuesta.setDescripcion("El parametro [movimiento] excede tamano (3)");
		}

		if (material.getOrdenCompra() == null || material.getOrdenCompra().equals("")) {
			respuesta.setEstatus("DDA-201 ");
			respuesta.setDescripcion("Falta informacion en parametros [orden compra]");
		}
		else if (material.getOrdenCompra().length() > 10) {
			respuesta.setEstatus("DDA-202");
			respuesta.setDescripcion("El parametro [orden compra] excede tamano (10)");
		}

		return respuesta;

	}

	/**
	 * INTERFAZ 43
	 * 
	 * @param material
	 *            pedido que va a verificar que esten todos sus datos y que no sobrepasen el tamano en la base
	 * @return RespuestaDTO regresa un objeto respuesta que contiene los campos estatus y descripcion
	 */
	public RespuestaDTO verificar(ModificarPedidoDTO material) {

		RespuestaDTO respuesta = new RespuestaDTO();
		respuesta.setEstatus("OK");
		respuesta.setDescripcion("Datos registrados correctamente en DDA");

		if (material.getOrdenCompra() == null || material.getOrdenCompra().equals("")) {
			respuesta.setEstatus("DDA-201");
			respuesta.setDescripcion("Falta informacion en [orden compra]");
		}
		else if (material.getOrdenCompra().length() > 10) {
			respuesta.setEstatus("DDA-202");
			respuesta.setDescripcion("El parametro [orden compra] excede tamanio (10)");
		}

		if (material.getPosicion() == null || material.getPosicion().equals("")) {
			respuesta.setEstatus("DDA-201 ");
			respuesta.setDescripcion("Falta informacion en parametros [posicion]");
		}
		else if (material.getPosicion().length() > 5) {
			respuesta.setEstatus("DDA-202");
			respuesta.setDescripcion("El parametro [posicion] excede tamano (5)");
		}

		if (material.getCodigoMaterial() == null || material.getCodigoMaterial().equals("")) {
			respuesta.setEstatus("DDA-201 ");
			respuesta.setDescripcion("Falta informacion en parametros [codigoMaterial]");
		}
		else if (material.getCodigoMaterial().length() > 18) {
			respuesta.setEstatus("DDA-202");
			respuesta.setDescripcion("El parametro [codigoMaterial] excede tamano (18)");
		}

		if (material.getImporte() == null || material.getImporte().equals("")) {
			respuesta.setEstatus("DDA-201 ");
			respuesta.setDescripcion("Falta informacion en parametros [importe]");
		}
		else if (!verificarNumero(material.getImporte()) || material.getImporte().length() > 17) {
			respuesta.setEstatus("DDA-202");
			respuesta.setDescripcion("El parametro [importe] no es un numero valido o excede tamano (17)");
		}

		if (material.getLicencia() == null || material.getLicencia().equals("")) {
			respuesta.setEstatus("DDA-201 ");
			respuesta.setDescripcion("Falta informacion en parametros [licencia]");
		}
		else if (material.getLicencia().length() > 12) {
			respuesta.setEstatus("DDA-202");
			respuesta.setDescripcion("El parametro [licencia] excede tamano (12)");
		}

		// INDICADOR EF: Son opcionales y no requieren validacion para saber si viene o no el dato,
		// solo requiere validacion de tamaño de dato
		if (material.getIndicadorEF().length() > 1) {
			respuesta.setEstatus("DDA-202");
			respuesta.setDescripcion("El parametro [indicadorEF] excede tamano (1)");
		}

		// INDICADOR FACTURA FINAL: Son opcionales y no requieren validacion para saber si viene o no el dato,
		// solo requiere validacion de tamaño de dato
		if (material.getIndicadorFacturaFinal().length() > 1) {
			respuesta.setEstatus("DDA-202");
			respuesta.setDescripcion("El parametro [indicador factura final] excede tamano (1)");
		}

		return respuesta;

	}

	public boolean verificarNumero(String numero) {
		// 1234567890123.12
		String pattern = "^(\\d){0,13}\\.?\\d{0,2}$";
		Pattern r = Pattern.compile(pattern);
		Matcher m = r.matcher(numero);
		return m.find();
	}

}
