package com.mx.dla.dda.contrato.pedido.tranform;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;

import com.mx.dla.dda.contrato.pedido.dtos.AgregarPedidoDTO;
import com.mx.dla.dda.contrato.pedido.dtos.ContratoMaterialDTO;
import com.mx.dla.dda.contrato.pedido.dtos.ModificarPedidoDTO;
import com.mx.dla.dda.contrato.pedido.dtos.NotificarPedidoDTO;
import com.mx.dla.dda.contrato.pedido.dtos.PedidoI37DTO;
import com.mx.dla.dda.contrato.pedido.dtos.PedidoI39DTO;
import com.mx.dla.dda.contrato.pedido.dtos.PedidoI43DTO;
import com.mx.dla.dda.contrato.pedido.generales.dtos.RespuestaDTO;

public class TransformaSAPtoDDA {

	private static Logger log = Logger.getLogger(TransformaSAPtoDDA.class);

	public ContratoMaterialDTO transformaContratoMaterial(AgregarPedidoDTO material) {
		ContratoMaterialDTO insert = new ContratoMaterialDTO();

		insert.setPosicion(material.getPosicion() != null ? material.getPosicion().trim() : null);
		insert.setCodigoMaterial(material.getCodigoMaterial() != null ? material.getCodigoMaterial().trim() : null);
		insert.setImporte(material.getImporte() != null ? material.getImporte().trim() : null);
		insert.setOrdenCompra(material.getOrdenCompra() != null ? material.getOrdenCompra().trim() : null);
		//insert.setFechaModif(new Date());

		return insert;
	}

	public ContratoMaterialDTO transformaContratoMaterial(ModificarPedidoDTO material) {
		ContratoMaterialDTO insert = new ContratoMaterialDTO();

		insert.setPosicion(material.getPosicion() != null ? material.getPosicion().trim() : null);
		insert.setCodigoMaterial(material.getCodigoMaterial() != null ? material.getCodigoMaterial().trim() : null);
		insert.setImporte(material.getImporte() != null ? material.getImporte().trim() : null);
		insert.setOrdenCompra(material.getOrdenCompra() != null ? material.getOrdenCompra().trim() : null);
		//insert.setFechaModif(new Date());

		Long licencia = Long.parseLong(material.getLicencia());

		insert.setLicencia(licencia);
		insert.setIndicadorEf(material.getIndicadorEF() != null ? material.getIndicadorEF().trim() : null);
		insert.setIndicadorFf(material.getIndicadorFacturaFinal() != null ? material.getIndicadorFacturaFinal().trim() : null);

		return insert;
	}

	public ContratoMaterialDTO transformaContratoMaterial(NotificarPedidoDTO material) {
		ContratoMaterialDTO insert = new ContratoMaterialDTO();

		insert.setPosicion(material.getPosicionPO() != null ? material.getPosicionPO().trim() : null);
		insert.setCodigoMaterial(material.getCodigoMaterial() != null ? material.getCodigoMaterial().trim() : null);
		insert.setImporte(material.getImporte() != null ? material.getImporte().trim() : null);
		insert.setOrdenCompra(material.getOrdenCompra() != null ? material.getOrdenCompra().trim() : null);
		//insert.setFechaModif(new Date());

		insert.setEjercicio(material.getEjercicio() != null ? material.getEjercicio().trim() : null);
		insert.setDoctoMaterial(material.getMaterial() != null ? material.getMaterial().trim() : null);
		insert.setMovimiento(material.getMovimiento() != null ? material.getMovimiento().trim() : null);
		insert.setDoctoPosicion(material.getPosicion() != null ? material.getPosicion().trim() : null);

		return insert;
	}

	public PedidoI37DTO tranformaAgregarPedioToPedidoI37(AgregarPedidoDTO material, RespuestaDTO respuesta) {
		PedidoI37DTO insert = new PedidoI37DTO();

		insert.setPosicion(material.getPosicion());
		insert.setCodigoMaterial(material.getCodigoMaterial());

		insert.setLicencia(material.getLicencia());

		insert.setImporte(material.getImporte());
		insert.setOrdenCompra(material.getOrdenCompra());

		insert.setEstatus(respuesta.getEstatus());
		insert.setDescripcion(respuesta.getDescripcion());

		return insert;
	}

	public PedidoI39DTO tranformaNotificarPedioToPedidoI39(NotificarPedidoDTO material, RespuestaDTO respuesta) {
		PedidoI39DTO insert = new PedidoI39DTO();

		insert.setCodigoMaterial(material.getCodigoMaterial());
		insert.setEjercicio(material.getEjercicio());
		insert.setPosicion(material.getPosicion());
		insert.setMaterial(material.getMaterial());

		insert.setImporte(material.getImporte());
		insert.setPosicionPO(material.getPosicionPO());
		insert.setMovimiento(material.getMovimiento());
		insert.setOrdenCompra(material.getOrdenCompra());

		insert.setEstatus(respuesta.getEstatus());
		insert.setDescripcion(respuesta.getDescripcion());

		return insert;
	}

	public PedidoI43DTO tranformaModificarPedioToPedidoI43(ModificarPedidoDTO material, RespuestaDTO respuesta) {
		PedidoI43DTO insert = new PedidoI43DTO();

		insert.setPosicion(material.getPosicion());
		insert.setCodigoMaterial(material.getCodigoMaterial());

		insert.setLicencia(material.getLicencia());
		insert.setIndicadorEF(material.getIndicadorEF());
		insert.setIndicadorFacturaFinal(material.getIndicadorFacturaFinal());
		insert.setImporte(material.getImporte());

		insert.setOrdenCompra(material.getOrdenCompra());

		insert.setEstatus(respuesta.getEstatus());
		insert.setDescripcion(respuesta.getDescripcion());

		return insert;
	}

}
