package com.mx.dla.dda.activos.amortizacion.bos;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.activos.amortizacion.daos.AmortizacionDAO;
import com.mx.dla.dda.activos.amortizacion.dtos.AmortizacionBD;
import com.mx.dla.dda.activos.amortizacion.dtos.AmortizacionDTO;
import com.mx.dla.dda.activos.amortizacion.generales.dtos.RespuestaDTO;
import com.mx.dla.dda.activos.amortizacion.trans.TransformacionSAPToDDA;
import com.mx.dla.dda.common.exception.ValidacionException;
import com.mx.dla.dda.utilerias.BeanUtilerias;

public class AmortizacionBO {

	private static Logger   log = Logger.getLogger(AmortizacionBO.class);

	@Autowired
	private AmortizacionDAO activoFijoDAO;

	public RespuestaDTO notificarAmortizacionMensual(List<AmortizacionDTO> activosFijos) {

		// List<RespuestaDTO> respuestas = new ArrayList<RespuestaDTO>();
		RespuestaDTO respuesta = null;
		List<AmortizacionBD> requests = new ArrayList<AmortizacionBD>();
		boolean valido = true;
		String codigoActivo = null;
		String mes = null;
		String mesValida = null;
		String subnumero = null;

		try {
			for (AmortizacionDTO activoFijo : activosFijos) {

				AmortizacionBD amortizacionDestino = null;
				AmortizacionBD amortizacionOrigen = null;
				Long idTitCtoOri = null;
				LinkedList<AmortizacionBD> amortizacionesAuxiliar = null;

				log.info("    <<<< Datos del activo fijo >>> ");

				BeanUtilerias.trimStrings(activoFijo);

				codigoActivo = activoFijo.getCodigoActivo();
				subnumero = activoFijo.getSubnumero();
				mes = activoFijo.getMes();

				log.info("     Inicio de la validacion del activo fijo: " + codigoActivo + " con mes " + mes);
				respuesta = verificar(activoFijo);

				if (!respuesta.getEstatus().equals("OK"))
					throw new ValidacionException(respuesta.getDescripcion());

				if (mesValida == null)
					mesValida = new String(mes);
				else if (!mesValida.equals(mes))
					throw new ValidacionException("Mes del activo fijo validado no corresponde al esperado. Validado: " + mes + " Esperado: " + mesValida);

				amortizacionDestino = TransformacionSAPToDDA.getAmortizacionBD(activoFijo);

				/*
				amortizacionesAuxiliar = new LinkedList<AmortizacionBD>(activoFijoDAO.buscaAmortizacionSap(amortizacionDestino));

				if (amortizacionesAuxiliar != null && !amortizacionesAuxiliar.isEmpty())
					if (amortizacionesAuxiliar.size() > 1)
						throw new ValidacionException("Existe mas de un registro asociado a los parametros enviados");
					else
						amortizacionOrigen = amortizacionesAuxiliar.getFirst();
				else
					amortizacionOrigen = new AmortizacionBD();
				*/

				idTitCtoOri = activoFijoDAO.getIdSapDeCtoTitulo(codigoActivo,subnumero);

				// if (idTitCtoOri == null)
				// throw new ValidacionException("No existe titulo original asociado al activo fijo: " + codigoActivo);

				amortizacionDestino.setIdCtoOriTit(idTitCtoOri);

				// amortizacionDestino = BeanUtilerias.mergeNotNullProperties(amortizacionOrigen, amortizacionDestino,
				// new String[] {}, AmortizacionBD.class);

				requests.add(amortizacionDestino);

				log.info("     Fin de la validacion del activo fijo " + codigoActivo + " con mes " + mes + ", resultado: " + respuesta.getEstatus());
			}
		}
		catch (Exception e) {
			respuesta.setDescripcion(e.getMessage());
			respuesta.setEstatus("ERROR");
			log.info("    Fin de la validacion del activo fijo " + codigoActivo + " con mes " + mes + ", resultado: " + respuesta.getEstatus() + " - " + e.getMessage());
			valido = false;
		}

		if (valido) {

			Long registro = 0L;

			try {

				AmortizacionBD borrado = new AmortizacionBD();
				borrado.setMes(mes);

				log.info("    Inicia borrado de registros con mes: " + mes);
				activoFijoDAO.eliminaAmortizacionMensual(borrado);
				log.info("    Termina borrado de registros con mes: " + mes);

				log.info("    Inicia persistencia   ");

				for (AmortizacionBD activoFijo : requests) {

					log.info("      Registro " + registro + " : " + activoFijo);

					codigoActivo = activoFijo.getCodigoActivo();
					mes = activoFijo.getMes();
					// log.info("   Inicia persistencia del activo fijo: " + codigoActivo);

					if (activoFijo.getIdAmortizacion() != null)
						activoFijoDAO.actualizarAmortizacionMensualDLA(activoFijo);
					else activoFijoDAO.notificarAmortizacionMensualDLA(activoFijo); 

					registro++;

					// log.info("    Fin persistencia del activo fijo: " + codigoActivo + " con resultado: " +
					// respuesta.getEstatus() + " - " + respuesta.getDescripcion());
				}
				log.info("    Fin persistencia con resultado: " + respuesta.getEstatus() + " - " + respuesta.getDescripcion());

			}
			catch (Exception e) {
				respuesta.setDescripcion(e.getMessage());
				respuesta.setEstatus("ERROR");
				log.info("   Fin persistencia con resultado: " + respuesta.getEstatus() + " en codigo activo " + codigoActivo + " y mes " + mes + " *** " + respuesta.getDescripcion() + " *** ");

			}

		}
		return respuesta;
	}

	public RespuestaDTO verificar(AmortizacionDTO activoFijo) {

		RespuestaDTO respuesta = new RespuestaDTO();
		respuesta.setEstatus("OK");
		respuesta.setDescripcion("Datos registrados correctamente en DDA");

		if (activoFijo.getMes() == null || activoFijo.getMes().equals("") )// null,
		                                                                                                          // mm-yyyy
		{
			respuesta.setEstatus("DDA-201");
			respuesta.setDescripcion("Falta informacion en parametros[mes]");
		}else if (!verificarFecha(activoFijo.getMes())){
			respuesta.setEstatus("DDA-202");
			respuesta.setDescripcion("El formato del campo [mes] no es el adecuado (MM-YYYY)");
		}

		if (activoFijo.getCodigoActivo() == null || activoFijo.getCodigoActivo().equals("")) {
			respuesta.setEstatus("DDA-201");
			respuesta.setDescripcion("Falta informacion en parametros[codigoActivo]");
		}
		else if (activoFijo.getCodigoActivo().length() > 12) {
			respuesta.setEstatus("DDA-202");
			respuesta.setDescripcion("El parametro [CodigoActivo] excede tamaño");
			activoFijo.setCodigoActivo(this.verificarLongitud(activoFijo.getCodigoActivo(), 12));
		}

		if (activoFijo.getMontoActual() == null || activoFijo.getMontoActual().equals("")) {
			respuesta.setEstatus("DDA-201");
			respuesta.setDescripcion("Falta informacion en parametros[montoActual]");
		}
		else if (!verificarNumero(activoFijo.getMontoActual(), false)) {
			respuesta.setEstatus("DDA-202");
			respuesta.setDescripcion("El parametro [montoActual] no empata con el formado 13 o 1 enteros . 12 o 0 decimales");
			activoFijo.setMontoActual(this.verificarLongitud(activoFijo.getMontoActual(), 16));
		}

		if (activoFijo.getMontoAcumulado() == null || activoFijo.getMontoAcumulado().equals("")) {
			respuesta.setEstatus("DDA-201");
			respuesta.setDescripcion("Falta informacion en parametros[montoAcumulado]");
		}
		else if (!verificarNumero(activoFijo.getMontoAcumulado(), false)) {
			respuesta.setEstatus("DDA-202");
			respuesta.setDescripcion("El parametro [montoAcumulado] no empata con el formado 13 o 1 enteros . 12 o 0 decimales");
			activoFijo.setMontoAcumulado(this.verificarLongitud(activoFijo.getMontoAcumulado(), 16));
		}

		if (activoFijo.getSubnumero() == null || activoFijo.getSubnumero().equals("")) {
			respuesta.setEstatus("DDA-201");
			respuesta.setDescripcion("Falta informacion en parametros[subnumero]");
		}
		else if (activoFijo.getSubnumero().length() > 4) {
			respuesta.setEstatus("DDA-202");
			respuesta.setDescripcion("El parametro [subNumero] excede tamano");
			activoFijo.setSubnumero(this.verificarLongitud(activoFijo.getSubnumero(), 4));
		}

		if (activoFijo.getVnc() == null || activoFijo.getVnc().equals("")) {
			respuesta.setEstatus("DDA-201");
			respuesta.setDescripcion("Falta informacion en parametros[vnc]");
		}
		else if (!isNumber(activoFijo.getVnc().trim())) {
			respuesta.setEstatus("DDA-202");
			respuesta.setDescripcion("El parametro [VNC] no empata con el formado 13 o 1 enteros . 12 o 0 decimales");
			activoFijo.setVnc(this.verificarLongitud(activoFijo.getVnc().trim(), 16));
		}

		return respuesta;
	}

	public boolean verificarFecha(String fecha) {
		return Pattern.matches("\\d\\d-\\d\\d\\d\\d", fecha);
	}

	public String verificarLongitud(String str, int tamano) {
		if (str.length() > tamano)
			return str.substring(0, tamano);
		else
			return str;
	}

	public boolean verificarNumero(String numero, boolean positivos) {
		String pattern = positivos ? "^(\\d){0,13}\\.?\\d{0,12}$" : "^-?(\\d){0,13}\\.?\\d{0,12}$";
		Pattern r = Pattern.compile(pattern);
		Matcher m = r.matcher(numero);
		return m.find();
	}
	
	public boolean isNumber(String input) {
		try {
            double numero = Double.parseDouble(input);
            return true;
        } catch (NumberFormatException e) {
        	return false;
        }
	}

}
