package com.mx.dla.dda.facturacion.bos;


import java.util.Iterator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.apache.log4j.Logger;
import com.americamovil.dda._1.f.enviafactura.DTFactura;
import com.americamovil.dda._1.f.enviafactura.DTNotaCredito;
import com.mx.dla.dda.facturacion.daos.FacturasDAO;
import com.mx.dla.dda.facturacion.dtos.FacturaDTO;
import com.mx.dla.dda.facturacion.dtos.FacturaDetalleDTO;
import com.mx.dla.dda.facturacion.dtos.NotaCreditoDTO;
import com.mx.dla.dda.facturacion.dtos.NotaCreditoDetalleDTO;

@Component
@PropertySource("classpath:interfaces.properties")
public class FacturaBO {

    private static Logger log = Logger.getLogger(FacturaBO.class);
    
    private WebServiceTemplate wsLogin;
    
    @Autowired
	private Environment env;
    
    
	@Autowired
	private FacturasDAO facturasDAO;
    
    private FacturaBO() {
    }

    public FacturaDTO notificarFactura( DTFactura _enviaFactura_mtFactura ) throws java.lang.Exception {

    	com.americamovil.dda._1.f.enviafactura.DTFacturaRes _enviaFactura__return = null;
        	   
        log.info("Invoking enviaFactura...");

    	FacturaDTO facturaDTO = new FacturaDTO();
    	facturaDTO.setSociedad(_enviaFactura_mtFactura.getFactura().getSociedad());
    	facturaDTO.setReferencia(_enviaFactura_mtFactura.getFactura().getReferencia());
    	facturaDTO.setIndicador(_enviaFactura_mtFactura.getFactura().getIndicador());
    	facturaDTO.setTipoDoc(_enviaFactura_mtFactura.getFactura().getTipoDoc());
    	facturaDTO.setFechaContabilidad(_enviaFactura_mtFactura.getFactura().getFechaContabilizacion());
    	facturaDTO.setFechaFactura( _enviaFactura_mtFactura.getFactura().getFechaFactura() );
    	facturaDTO.setMoneda(_enviaFactura_mtFactura.getFactura().getMoneda());
    	facturaDTO.setTexto(_enviaFactura_mtFactura.getFactura().getTexto());
    	facturaDTO.setMonto(_enviaFactura_mtFactura.getFactura().getMonto());
    	
    	
        try {
        	_enviaFactura__return = (com.americamovil.dda._1.f.enviafactura.DTFacturaRes) wsLogin.marshalSendAndReceive(env.getProperty("facturacion.clientws.wsdlLocation.i14"), _enviaFactura_mtFactura);
       
        	facturaDTO.setEstatusDda("OK");
        	facturaDTO.setrFactura(_enviaFactura__return.getRespuesta().getFactura());
        	facturaDTO.setrEstatus(_enviaFactura__return.getRespuesta().getStatus());
        	facturaDTO.setrMensaje(_enviaFactura__return.getRespuesta().getMensaje());        	


        	
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
			facturaDTO.setEstatusDda("DDA-301");        	
		}


        try {
        	/**
        	 * Registrar factura y detalle
        	 */
        	log.info("Registrar factura");       
        	facturasDAO.registraFactura(facturaDTO);
        	log.info("id de factura registrada: " + facturaDTO.getIdFactura() );        	
        	
        	/**
        	 * Registrar detalle de factura
        	 */        	
        	for (Iterator<DTFactura.Factura.Posicion> iterator = _enviaFactura_mtFactura.getFactura().getPosicion().iterator(); iterator.hasNext();) {
        		DTFactura.Factura.Posicion posicion = (DTFactura.Factura.Posicion) iterator.next();
        		
        		FacturaDetalleDTO facturaDetalleDTO = new FacturaDetalleDTO();
        		
        		facturaDetalleDTO.setIdFactura(facturaDTO.getIdFactura());
        		facturaDetalleDTO.setPosicion(posicion.getPosicion());
        		facturaDetalleDTO.setPedido(posicion.getPedido());
        		facturaDetalleDTO.setImpuesto(posicion.getIndImpuesto());
        		facturaDetalleDTO.setPosicionPO(posicion.getPosicionPO());
        		facturaDetalleDTO.setImporte(posicion.getImporte());
        		facturaDetalleDTO.setCantidad(posicion.getCantidad());
        		facturaDetalleDTO.setUnMedidaISO(posicion.getUnMedidaISO());
        		
        		try {
		        	log.info("Registrar detalle de factura");       
		        	facturasDAO.registraFacturaDetalle(facturaDetalleDTO);
		        	log.info("id de posicion registrada: " + facturaDTO.getIdFactura() );        					
				} catch (Exception e) {
					// TODO: handle exception
					log.info(e.getMessage());
					e.printStackTrace();
				}
        		
			}
        	
        	log.info("Factura registrada");
		} catch (Exception sqle) {
			// TODO: handle exception
			log.info(sqle.getMessage());
			sqle.printStackTrace();
		}
        
        log.info("enviaFactura.result=" + _enviaFactura__return);

        return facturaDTO;
        
    }

    public NotaCreditoDTO cargarNotaCredito( DTNotaCredito _enviaNotaCredito_mtNotaCredito ) throws java.lang.Exception {
    	
    	com.americamovil.dda._1.f.enviafactura.DTFacturaRes _enviaFactura__return = null;

        log.info("Invoking enviaNotaCredito...");

    	NotaCreditoDTO notaCreditoDTO = new NotaCreditoDTO();
    	
    	notaCreditoDTO.setSociedad(_enviaNotaCredito_mtNotaCredito.getRegistro().getSociedad());
    	notaCreditoDTO.setReferencia(_enviaNotaCredito_mtNotaCredito.getRegistro().getReferencia());    	
    	notaCreditoDTO.setIndicador(_enviaNotaCredito_mtNotaCredito.getRegistro().getIndFactura() );
    	notaCreditoDTO.setTipoDoc(_enviaNotaCredito_mtNotaCredito.getRegistro().getTipoDoc());
    	notaCreditoDTO.setFechaContabilidad(_enviaNotaCredito_mtNotaCredito.getRegistro().getFechaContab());
    	notaCreditoDTO.setFechaNotaCredito( _enviaNotaCredito_mtNotaCredito.getRegistro().getFechaNotaCred());
    	notaCreditoDTO.setMoneda(_enviaNotaCredito_mtNotaCredito.getRegistro().getMoneda());
    	notaCreditoDTO.setTexto(_enviaNotaCredito_mtNotaCredito.getRegistro().getTexto());
    	notaCreditoDTO.setMonto(_enviaNotaCredito_mtNotaCredito.getRegistro().getMonto());
    	
    	
        try {
          
            _enviaFactura__return = (com.americamovil.dda._1.f.enviafactura.DTFacturaRes) wsLogin.marshalSendAndReceive(env.getProperty("facturacion.clientws.wsdlLocation.i14"), _enviaNotaCredito_mtNotaCredito);
            System.out.println(env.getProperty("facturacion.clientws.wsdlLocation.i14"));
        	notaCreditoDTO.setEstatusDda("OK");
        	notaCreditoDTO.setrFactura(_enviaFactura__return.getRespuesta().getFactura());
        	notaCreditoDTO.setrEstatus(_enviaFactura__return.getRespuesta().getStatus());
        	notaCreditoDTO.setrMensaje(_enviaFactura__return.getRespuesta().getMensaje());

        	
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
			notaCreditoDTO.setEstatusDda("DDA-301");
		}


        try {
        	/**
        	 * Registrar nota de credito y detalle
        	 */
        	log.info("Registrar nota de credito");
        	facturasDAO.registraNotaCredito(notaCreditoDTO);
        	log.info("id de factura (nota de credito) registrada: " + notaCreditoDTO.getIdFactura() );        	
        	
        	/**
        	 * Registrar detalle de factura (nota credito)
        	 */        	
        	for (Iterator<DTNotaCredito.Registro.Item> iterator = _enviaNotaCredito_mtNotaCredito.getRegistro().getItem().iterator(); iterator.hasNext();) {
        		DTNotaCredito.Registro.Item item = (DTNotaCredito.Registro.Item) iterator.next();
        		
        		NotaCreditoDetalleDTO notaCreditoDetalleDTO = new NotaCreditoDetalleDTO();        		
        		notaCreditoDetalleDTO.setIdFactura(notaCreditoDTO.getIdFactura());
        		notaCreditoDetalleDTO.setPosicion(item.getPosicionDoc());
        		notaCreditoDetalleDTO.setPedido(item.getPedido());
        		notaCreditoDetalleDTO.setImpuesto(item.getIndImpuesto());
        		notaCreditoDetalleDTO.setPosicionPO(item.getPosicionPO());
        		notaCreditoDetalleDTO.setImporte(item.getImporte());
        		notaCreditoDetalleDTO.setCantidad(item.getCantidad());
        		notaCreditoDetalleDTO.setUnMedidaISO(item.getUnidMedISO());

        		try {
		        	log.info("Registrar detalle de factura (nota credito)");
		        	facturasDAO.registraNotaCreditoDetalle(notaCreditoDetalleDTO);
		        	log.info("id de item registrada: " + notaCreditoDetalleDTO.getIdFactura());        					
				} catch (Exception e) {
					// TODO: handle exception
					log.info(e.getMessage());
					e.printStackTrace();
				}
        		
			}
        	
        	log.info("Factura (nota de credito) registrada");
		} catch (Exception sqle) {
			// TODO: handle exception
			log.info(sqle.getMessage());
			sqle.printStackTrace();
		}
        
        log.info("enviaFactura.result=" + _enviaFactura__return);

        return notaCreditoDTO;
        
    }
    
	public WebServiceTemplate getWsLogin() {
		return wsLogin;
	}
	
	@Autowired
	public void setWsLogin(WebServiceTemplate wsLogin) {
		this.wsLogin = wsLogin;
	}
    
    
	
}
