package com.mx.dla.dda.facturacion.ws;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.americamovil.dda._1.f.enviafactura.DTFactura;
import com.americamovil.dda._1.f.enviafactura.DTNotaCredito;
import com.mx.dla.dda.facturacion.bos.FacturaBO;
import com.mx.dla.dda.facturacion.dtos.FacturaDTO;
import com.mx.dla.dda.facturacion.dtos.NotaCreditoDTO;

import org.apache.log4j.Logger;

@Controller
@RequestMapping("facturasWS")
public class FacturasWS {

	private static Logger log = Logger.getLogger(FacturasWS.class);

	@Autowired
	private FacturaBO facturaBO;

	@RequestMapping(value = "/notificarFactura", method = RequestMethod.POST, headers = "Accept=application/json; charset=utf-8", produces = {
			"application/xml", "application/json" })
	@ResponseBody
	public FacturaDTO notificarFactura(@RequestBody DTFactura _enviaFactura_mtFactura) {
		
		FacturaDTO respuesta = null;

		log.info("invoking resfull web service...");
		
		try {
			respuesta = facturaBO.notificarFactura(_enviaFactura_mtFactura);
		} catch (Exception e) {
			e.printStackTrace();
		}

		return respuesta;
	}

	@RequestMapping(value = "/cargarNotaCredito", method = RequestMethod.POST, headers = "Accept=application/json; charset=utf-8", produces = {
			"application/xml", "application/json" })
	@ResponseBody
	public NotaCreditoDTO cargarNotaCredito(@RequestBody DTNotaCredito _enviaNotaCredito_mtNotaCredito) {
		
		NotaCreditoDTO respuesta = null;

		log.info("invoking resfull web service...");

		try {
			respuesta = facturaBO.cargarNotaCredito(_enviaNotaCredito_mtNotaCredito);
		} catch (Exception e) {
			e.printStackTrace();
		}

		return respuesta;
	}	
	
		
}
