package com.mx.dla.dda.facturacion.ws;

import java.util.List;

import javax.jws.WebService;
import javax.ws.rs.Path;

import org.apache.log4j.Logger;

import com.mx.dla.dda.facturacion.bos.FacturacionBO;
import com.mx.dla.dda.facturacion.dtos.FacturaDTO;
import com.mx.dla.dda.facturacion.dtos.FacturaVerificadaDTO;
import com.mx.dla.dda.facturacion.dtos.RespuestaDTO;
import com.mx.dla.dda.facturacion.dtos.RespuestaFacturaDTO;


@WebService(endpointInterface = "com.mx.dla.dda.facturacion.ws.IFacturacionWS", serviceName = "idabmlFacturas")
public class FacturacionWS implements IFacturacionWS {

	private static Logger log = Logger.getLogger(FacturacionWS.class);
	private FacturacionBO facturacionBO;
	
	@Override
	@Path("/notificarPago")
	public RespuestaDTO notificarPago(List<FacturaDTO> facturas) {

		log.info(">>>>> Inicia proceso notificarPago <<<<<");
		
		RespuestaDTO respuesta = facturacionBO.notificarPago(facturas);	
		
		if(respuesta != null && !respuesta.getEstatus().equals("OK")) 
			respuesta.setEstatus("ERROR");
		
		log.info(">>>>> Termina proceso notificarPago <<<<<");
		return respuesta;
	}

	@Override
	@Path("/notificarFacturaVerificada")
	public RespuestaDTO notificarFacturaVerificada(List<FacturaVerificadaDTO> facturas) {

		log.info("Inicia proceso servicio facturacion Verificacion.");
		
		RespuestaDTO respuesta = facturacionBO.notificarFacturaVerificada(facturas);			
		if(respuesta != null && !respuesta.getEstatus().equals("OK")) 
			respuesta.setEstatus("ERROR");
		
		log.info("Termina proceso servicio facturacion verificacion.");
		
		return respuesta;
	}
	
	public FacturacionBO getFacturacionBO() {
		return facturacionBO;
	}

	public void setFacturacionBO(FacturacionBO facturacionBO) {
		this.facturacionBO = facturacionBO;
	}
	
	
}
