package com.mx.dla.dda.ordenesinternas.ws;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.americamovil.dda._1.f.enviaordeninterna.DTOrdenInterna;
//import com.americamovil.dda._1.f.enviaordeninterna.DTOrdenInternaRes;
import com.americamovil.dda._1.f.enviapresupuestooi.DTPresupuestoOIReq;
//import com.americamovil.dda._1.f.enviapresupuestooi.DTPresupuestoOIRes;
import com.mx.dla.dda.ordenesinternas.bos.OrdenesInternasBO;
import com.mx.dla.dda.ordenesinternas.dtos.OrdenesInternasDTO;
import com.mx.dla.dda.ordenesinternas.dtos.PresupuestoDTO;

@Controller
@RequestMapping("ordenesInternasWS")
public class OrdenesInternasWS {

	private static Logger log = Logger.getLogger(OrdenesInternasWS.class);
	
	@Autowired
	private OrdenesInternasBO ordenesInternasBO;

	@RequestMapping(value = "/crearOrdenInterna", method = RequestMethod.POST, headers = "Accept=application/json; charset=utf-8", produces = {
			"application/xml", "application/json" })
	@ResponseBody
	public OrdenesInternasDTO crearOrdenInterna(
			@RequestBody DTOrdenInterna ordenInterna) {
		
		return ordenesInternasBO.intentaCrearOrdenInterna(ordenInterna);
	}

	@RequestMapping(value = "/modificarOrdenInterna", method = RequestMethod.POST, headers = "Accept=application/json; charset=utf-8", produces = {
			"application/xml", "application/json" })
	@ResponseBody
	public PresupuestoDTO modificarOrdenInterna(@RequestBody DTPresupuestoOIReq presupuesto) {
				
		
		PresupuestoDTO pre = ordenesInternasBO.intentaModicarOrdenInterna(presupuesto);
		log.info("Se regresa respueta");
		return pre;
	}

	public OrdenesInternasBO getOrdenesInternasBO() {
		return ordenesInternasBO;
	}

	public void setOrdenesInternasBO(OrdenesInternasBO ordenesInternasBO) {
		this.ordenesInternasBO = ordenesInternasBO;
	}

}
