package com.mx.dla.dda.pedidocompra.bos;

import java.net.MalformedURLException;
import java.net.URL;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.ws.client.core.WebServiceTemplate;

import com.americamovil.dda._1.enviaposicionpo.DTCreaPosicionPOReq;
import com.americamovil.dda._1.enviaposicionpo.DTModificaPosicionPO;
import com.americamovil.dda._1.enviaposicionpo.DTMovimientoFinalPO;
import com.americamovil.dda._1.enviaposicionpo.DTPosicionPORes;
import com.mx.dla.dda.pedidocompra.daos.PedidoCompraDAO;
import com.mx.dla.dda.pedidocompra.dtos.DDA_I172334DTO;
import com.mx.dla.dda.pedidocompra.dtos.DDA_I17_DETDTO;
import com.mx.dla.dda.pedidocompra.dtos.DDA_I23_DETDTO;
import com.mx.dla.dda.pedidocompra.dtos.DDA_I34_DETDTO;

@Component
@PropertySource("classpath:interfaces.properties")
public class PedidoCompraBO {
	
	private WebServiceTemplate wsLogin;

	@Autowired
	private PedidoCompraDAO pedidoCompraDAO;
	
	@Autowired
	private Environment env;
	
	private static Logger log = Logger.getLogger(PedidoCompraBO.class);
	

	public DDA_I172334DTO consumeEnviaPosicion(DTCreaPosicionPOReq posicion) {
		
		System.out.println(posicion);
		System.out.println("Url wsdl: " + getWsdlURL("23"));
		DTPosicionPORes respuesta = null;
		DDA_I172334DTO dda_dto = null;
		DDA_I17_DETDTO dda_detdto = null;
		
		dda_dto = new DDA_I172334DTO();
		dda_dto.setId_documento(posicion.getPedidoCompra().getIDDocumento());

		try {
			
			respuesta = (DTPosicionPORes) wsLogin.marshalSendAndReceive(getWsdlURL("23").toString(), posicion);
			dda_dto.setEstatus_dda("OK");
			dda_dto.setR_documento(respuesta.getRespuesta().getDocumento());
			dda_dto.setR_id_mensaje(respuesta.getRespuesta().getIDMensaje());
			dda_dto.setR_mensaje(respuesta.getRespuesta().getMensaje());
			
		} catch (Exception e) {
			
			dda_dto.setEstatus_dda("DDA-301");
			e.printStackTrace();
			log.debug("Error: DDA-301");

		}
		
		pedidoCompraDAO.registraEnviaPosicion(dda_dto);
		
		dda_detdto = new DDA_I17_DETDTO();
		
		for(DTCreaPosicionPOReq.PedidoCompra.Item item : posicion.getPedidoCompra().getItem()){
			
			dda_detdto.setId_factura(dda_dto.getId_factura());
			dda_detdto.setCantidad(item.getCantidad());
			dda_detdto.setCentro(item.getCentro());
			dda_detdto.setCentro_costo(item.getCentroCosto());
			dda_detdto.setDocumento(item.getDocumento());
			dda_detdto.setId_material(item.getIDMaterial());
			dda_detdto.setIndicador_iva(item.getIndicadorIVA());
			dda_detdto.setNo_posicion(item.getNoPosicionPO());
			dda_detdto.setPosicion_po(item.getPosicionPO());
			dda_detdto.setPrecio(item.getPrecio());
			dda_detdto.setTipo_imputacion(item.getTipoImputacion());
			pedidoCompraDAO.registraDetalleEnviaPosicion(dda_detdto);
		}
		
		return dda_dto;
	}

	public DDA_I172334DTO consumeEnviaMovimientoFinal(DTMovimientoFinalPO movimiento) {
		
		System.out.println(movimiento);
		System.out.println("Url wsdl: " + getWsdlURL("23"));

		DTPosicionPORes respuesta = null;
		DDA_I172334DTO dda_dto = null;
		DDA_I34_DETDTO dda_detdto = null;

		dda_dto = new DDA_I172334DTO();
		dda_dto.setId_documento(movimiento.getRegistro().getNumDoc());

		try {
	
			respuesta = (DTPosicionPORes) wsLogin.marshalSendAndReceive(getWsdlURL("23").toString(), movimiento);

			dda_dto.setEstatus_dda("OK");
			dda_dto.setR_documento(respuesta.getRespuesta().getDocumento());
			dda_dto.setR_id_mensaje(respuesta.getRespuesta().getIDMensaje());
			dda_dto.setR_mensaje(respuesta.getRespuesta().getMensaje());

		} catch (Exception e) {

			dda_dto.setEstatus_dda("DDA-301");
			e.printStackTrace();
			log.debug("Error: DDA-301");
			
		}

		pedidoCompraDAO.registraMovimientoFinal(dda_dto);

		dda_detdto = new DDA_I34_DETDTO();

		for (DTMovimientoFinalPO.Registro.Item item : movimiento.getRegistro().getItem()) {
			dda_detdto.setId_factura(dda_dto.getId_factura());
			dda_detdto.setInd_entrega_fin(item.getIndEntregaFin());
			dda_detdto.setInd_factura_final(item.getIndFacturaFinal());
			dda_detdto.setNum_item(item.getNumItem());
			pedidoCompraDAO.registraDetalleMovimientoFinal(dda_detdto);
		}

		return dda_dto;
	}

	
	public DDA_I172334DTO consumeEnviaModificacionPosicion(DTModificaPosicionPO posicion) {
		
		System.out.println(posicion);
		System.out.println("Url wsdl: " + getWsdlURL("23"));
		
		DTPosicionPORes respuesta = null;
		DDA_I172334DTO dda_dto = null;
		DDA_I23_DETDTO dda_detdto = null;
		
		dda_dto = new DDA_I172334DTO();
		dda_dto.setId_documento(posicion.getRegistro().getDocumento());

		try {
			respuesta = (DTPosicionPORes) wsLogin.marshalSendAndReceive(getWsdlURL("23").toString(), posicion);
			
			
			dda_dto.setEstatus_dda("OK");
			dda_dto.setR_documento(respuesta.getRespuesta().getDocumento());
			dda_dto.setR_id_mensaje(respuesta.getRespuesta().getIDMensaje());
			dda_dto.setR_mensaje(respuesta.getRespuesta().getMensaje());
		
		} catch (Exception e) {
			
			dda_dto.setEstatus_dda("DDA-301");
			e.printStackTrace();
			log.debug("Error: DDA-301");

		}
		
		pedidoCompraDAO.registraModificarPosicion(dda_dto);
		
		dda_detdto = new DDA_I23_DETDTO();
		
		for(DTModificaPosicionPO.Registro.Posicion item: posicion.getRegistro().getPosicion()){
			dda_detdto.setId_factura(dda_dto.getId_factura());
			dda_detdto.setCantidad(item.getCantidad());
			dda_detdto.setNo_posicion(item.getNoPosicion());
			pedidoCompraDAO.registraDetalleModificarPosicion(dda_detdto);
		}
		
		return dda_dto;
	}
	
	public URL getWsdlURL(String idInterface){
		
		URL url = null;
		
        try {
            url = new URL(env.getProperty("pedidoCompra.clientws.wsdlLocation.i" + idInterface));
        } catch (MalformedURLException e) {
        	log.debug("No se pudo inicializar el wsdl " + url);
        }       
        return url;
    }

	public Environment getEnv() {
		return env;
	}

	public void setEnv(Environment env) {
		this.env = env;
	}

	public WebServiceTemplate getWsLogin() {
		return wsLogin;
	}
	
	@Autowired
	public void setWsLogin(WebServiceTemplate wsLogin) {
		this.wsLogin = wsLogin;
	}
	

}
