package com.mx.dla.dda.presupuesto.bos;


import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.presupuesto.daos.AmortizableDAO;
import com.mx.dla.dda.presupuesto.daos.PresupuestoDAO;
import com.mx.dla.dda.presupuesto.dtos.AmortizableDTO;
import com.mx.dla.dda.presupuesto.dtos.PresupuestoDTO;
import com.mx.dla.dda.presupuesto.generales.dtos.RespuestaDTO;


public class PresupuestoBO {
	private Logger log = Logger.getLogger(this.getClass());
	@Autowired
	private PresupuestoDAO presupuestoDAO;
	
	@Autowired
	private AmortizableDAO amortizableDAO;
	
	public RespuestaDTO agregarPresupuestoBO(PresupuestoDTO presupuesto){
		RespuestaDTO respuesta = new RespuestaDTO();
		boolean valido=true;
	
		log.info("    <<<< Datos del presupuesto >>>" );
		log.info( presupuesto.toString() );
		log.info("    Inicio de la validacion de la factura:" + presupuesto.getAnnio());
		respuesta=this.verificaPresupuesto(presupuesto);
		log.info("    Fin de la validacion de la presupuesto:" + presupuesto.getAnnio() + " con resultado: " + respuesta.getEstatus() );
		if( !respuesta.getEstatus().equals( "OK" ) )	{
			valido=false;			
			respuesta.setEstatus("ERROR");
			
		}
		
		try {
			
			if(valido){
				AmortizableDTO amortizable = new AmortizableDTO();
				List<AmortizableDTO> amortizableVerificador = new ArrayList<AmortizableDTO>();
				amortizable.setAnnio(presupuesto.getAnnio());
				amortizable.setMonto(presupuesto.getImporte());
				amortizableVerificador=amortizableDAO.verificaAmortizacion(amortizable.getAnnio());
			
				if(!amortizableVerificador.isEmpty()){
					amortizableDAO.actualizarAmortizable(amortizable);
					log.debug("ACABO DE HACER UPDATE");
					respuesta.setEstatus("OK");					
				}else{
					amortizableDAO.agregarPresupuestoAmortizable(amortizable);
					log.debug("ACABO DE AGREGAR");
					respuesta.setEstatus("OK");					
				}
			}
		
			//presupuestoDAO.agregarPresupuesto(presupuesto);
			
		}catch(SQLException e){
			log.error("ERROR:",e);
			log.error("Causa: "+e.getCause());
			respuesta.setEstatus("Error-501");			
		}
		return respuesta;
	}
	
	
	public RespuestaDTO verificaPresupuesto(PresupuestoDTO presupuesto){
		RespuestaDTO respuesta = new RespuestaDTO();
		respuesta.setEstatus("OK");		
		
		if( presupuesto.getImporte() == null || presupuesto.getImporte().equals("")  )
		{
			respuesta.setEstatus("DDA-201");			
		}
		else if(!verificarNumero(presupuesto.getImporte().trim())){
			respuesta.setEstatus("DDA-202");			
			presupuesto.setImporte(this.verificarLongitud(presupuesto.getImporte(), 15));
		}
		
		if( presupuesto.getAnnio() == null || presupuesto.getAnnio().equals("")  || 
				presupuesto.getAnnio().length() > 4 || !this.verificarAnnio(presupuesto.getAnnio()))
			{
				respuesta.setEstatus("DDA-201");				
			}
		return respuesta;
		
	}
	
	public String verificarLongitud(String str, int tamano){		   
		   if(str.length() > tamano)
			    return str.substring(0,tamano);
		   else
			   return str;
	}
	
	public boolean verificarNumero(String numero){
		//1234567890123.12  
		String pattern = "^(\\d){0,13}\\.?\\d{0,2}$"; 
		 Pattern r = Pattern.compile(pattern);
		 Matcher m = r.matcher(numero);
		 return m.find( );
	}
	
	public boolean verificarAnnio(String fecha){
		return Pattern.matches("\\d\\d\\d\\d", fecha);
	}
		
}
