package com.mx.dla.dda.catalogo.material.ws;
import javax.jws.WebService;
import javax.ws.rs.Path;

import org.apache.log4j.Logger;

import com.mx.dla.dda.catalogo.generales.dtos.RespuestaDTO;
import com.mx.dla.dda.catalogo.material.bos.MaterialBO;
import com.mx.dla.dda.catalogo.material.dtos.MaterialCollectionDTO;
/**
 * 
 * @author RFD
 *@see para desplegarlo hay que seguir el patron: http://ipAddress:port/projectName/services/
 *			ejemplo: http://localhost:8088/ddaCatalogosWS/services/abmlTitulosSap?wsdl
 *
 */
@WebService(endpointInterface = "com.mx.dla.dda.catalogo.material.ws.IMaterialWS", serviceName = "idabmlTitulosSap")
public class MaterialWS implements IMaterialWS {

	private static Logger log = Logger.getLogger(MaterialWS.class);
	private MaterialBO materialBO;

	@Override
	@Path("/agregarTitulosSap")
	public RespuestaDTO agregarTitulosSap(MaterialCollectionDTO parametro) {

		RespuestaDTO respuesta = new RespuestaDTO();
		respuesta.setEstatus("ERROR");

		try {

			log.info("------- Inicio de WS de carga de Titulos Sap -------");			
			respuesta = materialBO.agregaMaterialBO(parametro);
			
			if(!respuesta.getEstatus().equals("OK")) respuesta.setEstatus("ERROR");
			log.info("------- Fin de WS de carga de Titulos SAP -------");

		} catch (Exception exc) {
			log.info("Ocurrio un error en agregarTituloSap");
			log.info(exc.getMessage());
		}

		return respuesta;
	}

	public MaterialBO getMaterialBO() {
		return materialBO;
	}

	public void setMaterialBO(MaterialBO materialBO) {
		this.materialBO = materialBO;
	}

}
