package com.mx.dla.dda.bussiness.utilerias;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.springframework.util.StringUtils;

public class BussinessUtilerias {

	public static boolean validaSapNegativo(String numero) {
		String negativeString = "-";
		if (numero != null)
			if (numero.endsWith(negativeString) || numero.startsWith(negativeString))
				return true;
		return false;
	}

	public static String quitaNegativo(String numero) {
		char negativeString = "-".charAt(0);
		String importe = null;

		if (numero != null)
			if (validaSapNegativo(numero))
				importe = StringUtils.trimLeadingCharacter(StringUtils.trimTrailingCharacter(numero, negativeString), negativeString);
			else
				importe = new String(numero);

		return importe;
	}

	public static boolean validaImporte(String numero) {
		return verificarNumero(quitaNegativo(numero));
	}

	public static boolean verificarNumero(String numero) {
		// 1234567890123.12
		String pattern = "^(\\d){0,13}\\.?\\d{0,2}$";
		Pattern r = Pattern.compile(pattern);
		Matcher m = r.matcher(numero);
		return m.find();
	}
	

}