package com.mx.dla.dda.catalogo.estudio.bos;

import java.sql.SQLException;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.catalogo.estudio.daos.EstudioDAO;
import com.mx.dla.dda.catalogo.estudio.dtos.EstudioCollectionDTO;
import com.mx.dla.dda.catalogo.estudio.dtos.EstudioDTO;
import com.mx.dla.dda.catalogo.estudio.dtos.EstudioI2DTO;
import com.mx.dla.dda.catalogo.estudio.trans.TransformaSAPToDDA;
import com.mx.dla.dda.catalogo.generales.dtos.RespuestaDTO;
import java.util.HashMap;

public class EstudioBO {

	@Autowired
	private EstudioDAO estudioDAO;
	
	private static Logger log = Logger.getLogger(EstudioBO.class);

	public RespuestaDTO agregaEstudioBO(EstudioCollectionDTO estudios) {
		RespuestaDTO respuesta = null;
		EstudioI2DTO estudioI2DTO = null;
		Long idEstudio = null;
		boolean valido=true;
		
		for (EstudioDTO estudio : estudios.getEstudios()) {
			log.info("    <<<< Datos del estudio >>>" );				
			log.info( estudio.toString() );
			
			log.info("    Inicio de la validacion del estudio:" + estudio.getCodigoProveedor() );				
			respuesta = validaEstudio(estudio);
			log.info("    Fin de la validacion del estudio:" + estudio.getCodigoProveedor() + " con resultado: " + respuesta.getEstatus() );
			
			if( !respuesta.getEstatus().equals( "OK" ) )	{
				valido=false;
				log.info("Detalle de error: "+respuesta.getDescripcion());
				respuesta.setEstatus("ERROR");
				break;
			}
		}
		
		try {			
			
			for (EstudioDTO estudio : estudios.getEstudios()) {
				
				if(valido){
					
					estudioI2DTO = TransformaSAPToDDA.getEstudioI2DTO(estudio);
					estudioI2DTO.setDescripcion(respuesta.getDescripcion());
					estudioI2DTO.setEstatus(respuesta.getEstatus());
					estudioI2DTO.setSigla(null);
					estudioI2DTO.setIdGrupo("1");
					
					log.info("    Inicio de la busqueda el ID del estudio:" + estudio.getNombreProveedor() );
					idEstudio = estudioDAO.obtenerIdEstudio(estudioI2DTO.getCodigoProveedor());
					log.info("    Fin de la busqueda ID del estudio:" + idEstudio );
					
                                        HashMap<String, Object> params = new HashMap<String, Object>();
                                        String mensajeError;

					if(idEstudio == null){
						log.info("    Inicio de la insercion del estudio:" + idEstudio );
						estudioDAO.agregaEstudio(estudioI2DTO);
                                                
                                                estudioDAO.actualizarSiglasEstudios(params);
                                                mensajeError = (String) params.get("mensajeError");
                                                log.info(mensajeError);
						log.info("    Fin de la insercion del estudio:" + idEstudio );
					}else {
						log.info("    Inicio de la actualizacion del estudio:" + idEstudio );
						estudioI2DTO.setIdEstudio(idEstudio);
						estudioDAO.actualizaEstudio(estudioI2DTO);
                                                estudioDAO.actualizarSiglasEstudios(params);
                                                mensajeError = (String) params.get("mensajeError");
                                                log.info(mensajeError);
						log.info("    Fin de la actualizacion del estudio:" + idEstudio );
					}
				}
				
				
				
			}
			
			

		} catch (SQLException e) {
			log.info("Ocurrio un error en agregaEstudioBO");
			log.info(e.getMessage());
		}
		
		return respuesta;
	}
	
	private RespuestaDTO validaEstudio(EstudioDTO estudio){
		RespuestaDTO respuesta = new RespuestaDTO();
		
		respuesta.setEstatus("OK");
		respuesta.setDescripcion("Datos registrados correctamente");
		
		if(estudio.getCodigoPais() == null || estudio.getCodigoPais().equals("")){
			respuesta.setEstatus("DDA-201");
			respuesta.setDescripcion("Falta parmetro codigo pas");
		}else if(estudio.getCodigoPais().length() > 3){
			respuesta.setEstatus("DDA-202");
			respuesta.setDescripcion("El parmetro [CodigoPais] excede tamao");
			estudio.setCodigoPais(estudio.getCodigoPais().substring(0, 2));
		}
		
		if(estudio.getCodigoProveedor() == null || estudio.getCodigoProveedor().equals("")){
			respuesta.setEstatus("DDA-201");
			respuesta.setDescripcion("Falta parmetro codigo proveedor");
		}else if(estudio.getCodigoProveedor().length() > 10){
			respuesta.setEstatus("DDA-202");
			respuesta.setDescripcion("El parmetro [CodigoProveedor] excede tamao");
			estudio.setCodigoProveedor(estudio.getCodigoProveedor().substring(0, 10));
		}
		
		if(estudio.getMoneda() == null || estudio.getMoneda().equals("")){
			respuesta.setEstatus("DDA-201");
			respuesta.setDescripcion("Falta parmetro moneda");
		}else if(estudio.getMoneda().length() > 3){
			respuesta.setEstatus("DDA-202");
			respuesta.setDescripcion("El parmetro [moneda] excede tamao");
			estudio.setMoneda(estudio.getMoneda().substring(0, 3));
		}
		
		if(estudio.getNombrePais() == null || estudio.getNombrePais().equals("")){
			respuesta.setEstatus("DDA-201");
			respuesta.setDescripcion("Falta parmetro nombre pais");
		}else if(estudio.getNombrePais().length() > 20){
			respuesta.setEstatus("DDA-202");
			respuesta.setDescripcion("El parmetro [NombrePais] excede tamao");
			estudio.setNombrePais(estudio.getNombrePais().substring(0, 20));
		}
		
		if(estudio.getNombreProveedor() == null || estudio.getNombreProveedor().equals("")){
			respuesta.setEstatus("DDA-201");
			respuesta.setDescripcion("Falta parmetro nombre proveedor");
		}else if(estudio.getNombreProveedor().length() > 50){
			estudio.setNombreProveedor(estudio.getNombreProveedor().substring(0, 50));
		}
		
		if(estudio.getSociedad() == null || estudio.getSociedad().equals("")){
			respuesta.setEstatus("DDA-201");
			respuesta.setDescripcion("Falta parmetro sociedad");
		}else if(estudio.getSociedad().length() > 4){
			respuesta.setEstatus("DDA-202");
			respuesta.setDescripcion("El parmetro [sociedad] excede tamao");
			estudio.setSociedad(estudio.getSociedad().substring(0, 4));
		}
		
		return respuesta;
	}
}
