package com.mx.dla.dda.catalogo.material.bos;

import java.sql.SQLException;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import com.mx.dla.dda.catalogo.generales.dtos.RespuestaDTO;
import com.mx.dla.dda.catalogo.material.daos.MaterialDAO;
import com.mx.dla.dda.catalogo.material.dtos.MaterialCollectionDTO;
import com.mx.dla.dda.catalogo.material.dtos.MaterialDTO;
import com.mx.dla.dda.catalogo.material.dtos.MaterialI1DTO;
import com.mx.dla.dda.catalogo.material.trans.TransformaSAPToDDA;

public class MaterialBO {

	@Autowired
	private MaterialDAO materialDAO;
	
	private static Logger log = Logger.getLogger(MaterialBO.class);

	public RespuestaDTO agregaMaterialBO(MaterialCollectionDTO materiales) {
		RespuestaDTO respuesta = null;
		MaterialI1DTO materialI1DTO = null;
		Long idMaterial = null;
		boolean valido=true;
		
		for (MaterialDTO material : materiales.getMateriales()) {
			log.info("    <<<< Datos del material >>>" );				
			log.info( material.toString() );
			
			log.info("    Inicio de la validacion del material:" + material.getCodigo() );
			respuesta = validaMaterial(material);
			log.info("    Fin de la validacion del material:" + material.getCodigo() + " con resultado: " + respuesta.getEstatus() );
			
			if( !respuesta.getEstatus().equals( "OK" ) )	{
				valido=false;
				log.info("Detalle de error: "+respuesta.getDescripcion());
				respuesta.setEstatus("ERROR");
				break;
			}
			
		}
		
		
		
		try {
			
			for (MaterialDTO material : materiales.getMateriales()) {
					
				if( valido )	{
					
					materialI1DTO = TransformaSAPToDDA.getMaterialI1DTO(material);
					materialI1DTO.setDescripcion(respuesta.getDescripcion());
					materialI1DTO.setEstatus(respuesta.getEstatus());
					
					log.info("    Inicio de la busqueda el ID del material:" + material.getNombre() );
					idMaterial = materialDAO.obtenerIdMaterial(materialI1DTO.getCodigo());
					log.info("    Fin de la busqueda ID del material:" + idMaterial );
					
					if(idMaterial == null){
						
						log.info("    Inicio de la insercion del material:" + idMaterial );
						materialDAO.agregarMaterial(materialI1DTO);
						log.info("    Fin de la insercion del material:" + idMaterial );
						
					}else{
						
						log.info("    Inicio de la actualizacion del material:" + idMaterial );
						materialI1DTO.setIdMaterial(idMaterial);
						materialDAO.actualizaMaterial(materialI1DTO);
						log.info("    Fin de la actualizacion del material:" + idMaterial );
						
					}
				}				
			}					
			
		} catch (SQLException e) {
			log.info("Ocurrio un error en agregaMaterialBO");
			log.info(e.getMessage());
			 
		}
		return respuesta;
	}

	private RespuestaDTO validaMaterial(MaterialDTO material){
		RespuestaDTO respuesta = new RespuestaDTO();
		
		respuesta.setEstatus("OK");
		respuesta.setDescripcion("Datos registrados correctamente");
		
		if(material.getCodigo() == null || material.getCodigo().equals("")){
			respuesta.setEstatus("DDA-201");
			respuesta.setDescripcion("Falta parmetro codigo");
		}else if(material.getCodigo().length() > 18){
			respuesta.setEstatus("DDA-202");
			respuesta.setDescripcion("El parmetro [codigo] excede tamao");
			material.setCodigo(material.getCodigo().substring(0, 18));
		}
		
		if(material.getIso() == null || material.getIso().equals("")){
			respuesta.setEstatus("DDA-201");
			respuesta.setDescripcion("Falta parmetro iso");
		}else if(material.getIso().length() > 3){
			respuesta.setEstatus("DDA-202");
			respuesta.setDescripcion("El parmetro [iso] excede tamao");
			material.setIso(material.getIso().substring(0, 3));
		}
		
				
		if( material.getnMaterialAntiguo() != null && !material.getnMaterialAntiguo().equals("") && material.getnMaterialAntiguo().length() > 18){
			respuesta.setEstatus("DDA-202");
			respuesta.setDescripcion("El parmetro materialAntiguo excede tamao");
			material.setnMaterialAntiguo(material.getnMaterialAntiguo().substring(0, 18));
		}
		
		if(material.getNombre() == null || material.getNombre().equals("")){
			respuesta.setEstatus("DDA-201");
			respuesta.setDescripcion("Falta parmetro nombre");
		}else if(material.getNombre().length() > 40){
			respuesta.setEstatus("DDA-202");
			respuesta.setDescripcion("El parmetro [nombre] excede tamao");
			material.setNombre(material.getNombre().substring(0, 40));
		}
		
		if(material.getUnidad() == null || material.getUnidad().equals("")){
			respuesta.setEstatus("DDA-201");
			respuesta.setDescripcion("Falta parmetro unidad");
		}else if(material.getUnidad().length() > 3){
			respuesta.setEstatus("DDA-202");
			respuesta.setDescripcion("El parmetro [unidad] excede tamao");
			material.setUnidad(material.getUnidad().substring(0, 3));
		}
	
		return respuesta;
	}
}
