package com.mx.dla.dda.contrato.pedido.ws;

import java.util.List;

import javax.jws.WebService;
import javax.ws.rs.Path;

import org.apache.log4j.Logger;

import com.mx.dla.dda.contrato.pedido.bos.PedidoBO;
import com.mx.dla.dda.contrato.pedido.dtos.AgregarPedidoDTO;
import com.mx.dla.dda.contrato.pedido.dtos.ModificarPedidoDTO;
import com.mx.dla.dda.contrato.pedido.dtos.NotificarPedidoDTO;
import com.mx.dla.dda.contrato.pedido.generales.dtos.RespuestaDTO;

@WebService(endpointInterface = "com.mx.dla.dda.contrato.pedido.ws.IPedidoWS", serviceName = "pedido")
public class PedidoWS implements IPedidoWS {

	private static Logger log = Logger.getLogger(PedidoWS.class);

	private PedidoBO pedidoBO;

	@Override
	@Path("/agregarPedido")
	public RespuestaDTO agregarPedido(List<AgregarPedidoDTO> listaPedido) {

		log.info("Inicia el proceso de la Interfaz 37/38 Lista: " + listaPedido.get(0).toString());

		RespuestaDTO respuesta = pedidoBO.agregarPedido(listaPedido);
		if (respuesta.getEstatus() != null && !respuesta.getEstatus().equals("OK"))
			respuesta.setEstatus("ERROR");
		log.info("Termina el proceso de la Interfaz 37/38 Lista");
		return respuesta;
	}

	@Override
	@Path("/notificarEntrada")
	public RespuestaDTO notificarEntrada(List<NotificarPedidoDTO> listaPedido) {
		log.info("Inicia el proceso de la Interfaz 39/40");

		RespuestaDTO respuesta = pedidoBO.notificarEntrada(listaPedido);
		if (respuesta.getEstatus() != null && !respuesta.getEstatus().equals("OK"))
			respuesta.setEstatus("ERROR");
		log.info("Termina el proceso de la Interfaz 39/40");
		return respuesta;
	}

	@Override
	@Path("/modificarPedido")
	public RespuestaDTO modificarPedido(List<ModificarPedidoDTO> listaPedido) {
		log.info("Inicia el proceso de la Interfaz 43/44");

		RespuestaDTO respuesta = pedidoBO.modificarPedido(listaPedido);
		if (respuesta.getEstatus() != null && !respuesta.getEstatus().equals("OK"))
			respuesta.setEstatus("ERROR");
		
		log.info("Termina el proceso de la Interfaz 43/44");
		return respuesta;
	}

	public PedidoBO getPedidoBO() {
		return pedidoBO;
	}

	public void setPedidoBO(PedidoBO pedidoBO) {
		this.pedidoBO = pedidoBO;
	}

}
