package com.mx.dla.dda.activos.amortizacion.ws;

import java.util.List;

import javax.jws.WebService;
import javax.ws.rs.Path;

import org.apache.log4j.Logger;

import com.mx.dla.dda.activos.amortizacion.bos.AmortizacionBO;
import com.mx.dla.dda.activos.amortizacion.dtos.AmortizacionDTO;
import com.mx.dla.dda.activos.amortizacion.generales.dtos.RespuestaDTO;

@WebService(endpointInterface = "com.mx.dla.dda.activos.amortizacion.ws.IAmortizacionWS", serviceName = "idabmlActivoFijo")
public class AmortizacionWS implements IAmortizacionWS {

	private static Logger log = Logger.getLogger(AmortizacionWS.class);
	private AmortizacionBO amortizacionBO;

	@Override
	@Path("/notificarAmortizacionMensual")
	public RespuestaDTO notificarAmortizacionMensual(
			List<AmortizacionDTO> activo) {
		log.info("Inicia el proceso de la interfaz 13, n:" + activo.size());

		RespuestaDTO respuesta = amortizacionBO
				.notificarAmortizacionMensual(activo);
		if(respuesta.getEstatus() != null && !respuesta.getEstatus().equals("OK")) 
			respuesta.setEstatus("ERROR");
		
		log.info("Termina el proceso de la interfaz 13");
		return respuesta;
	}

	public AmortizacionBO getAmortizacionBO() {
		return amortizacionBO;
	}

	public void setAmortizacionBO(AmortizacionBO amortizacionBO) {
		this.amortizacionBO = amortizacionBO;
	}

}
