package com.mx.dla.dda.presupuesto.ws;

import javax.jws.WebService;
import javax.ws.rs.Path;

import org.apache.log4j.Logger;

import com.mx.dla.dda.presupuesto.bos.PresupuestoBO;
import com.mx.dla.dda.presupuesto.dtos.PresupuestoDTO;
import com.mx.dla.dda.presupuesto.generales.dtos.RespuestaDTO;


@WebService(endpointInterface = "com.mx.dla.dda.presupuesto.ws.IPresupuestoWS", serviceName = "idabmlPresupuesto")
public class PresupuestoWS implements IPresupuestoWS {

	private static Logger log = Logger.getLogger(PresupuestoWS.class);
	private PresupuestoBO presupuestoBO;
	
	@Override
	@Path("/notificarPresupuesto")
	public RespuestaDTO notificarPresupuesto(PresupuestoDTO presupuesto) {

		log.debug("------- Inicio para la carga de presupuesto ------");
		
		RespuestaDTO respuesta = new RespuestaDTO();
		respuesta.setEstatus("ERROR");

		try {
						
			respuesta = presupuestoBO.agregarPresupuestoBO(presupuesto);	
			if(!respuesta.getEstatus().equals("OK")) 
			   respuesta.setEstatus("ERROR");			
			log.info(">>>>> Termina proceso carga presupuesto <<<<<");

		} catch (Exception exc) {
			log.debug("Ocurrio un error en notificarPresupuesto");
			log.error(exc);						
			respuesta.setEstatus("ERROR");			
		}

		log.debug("------- Inicio para la carga de presupuesto ------");
		
		return respuesta;
	}

	public PresupuestoBO getPresupuestoBO() {
		return presupuestoBO;
	}

	public void setPresupuestoBO(PresupuestoBO presupuestoBO) {
		this.presupuestoBO = presupuestoBO;
	}
	
	
}
