package com.mx.dla.dda.utilerias;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;

public class BeanUtilerias {

	private static Logger log = Logger.getLogger(BeanUtilerias.class);

	public static void trimStrings(Object beanObject) throws Exception {
		Exception noSuchMethodException = null;
		boolean throwNoSuchMethodException = false;
		if (beanObject != null) {

			Method[] methods = null;

			try {
				methods = beanObject.getClass().getMethods();
			}
			catch (SecurityException e) {
				throw new Exception(e);
			}

			if (methods != null) {

				for (Method method : methods) {

					String methodName = method.getName();

					if (!methodName.equals("getClass")) {

						String returnType = method.getReturnType().toString();
						String commonMethodName = null;

						if (methodName.startsWith("get") && "class java.lang.String".equals(returnType)) {

							commonMethodName = methodName.replaceFirst("get", "");
							String returnedValue = null;

							try {
								returnedValue = (String) method.invoke(beanObject);
							}
							catch (IllegalArgumentException e) {
								e.printStackTrace();
								throw e;
							}
							catch (IllegalAccessException e) {
								e.printStackTrace();
								throw e;
							}
							catch (InvocationTargetException e) {
								e.printStackTrace();
								throw e;
							}

							if (returnedValue != null) {

								StringBuilder setterMethodName = new StringBuilder();
								setterMethodName.append("set");
								setterMethodName.append(commonMethodName);
								Method setterMethod = null;

								try {
									setterMethod = beanObject.getClass().getMethod(setterMethodName.toString(), String.class);
									if (setterMethod != null) {
										setterMethod.invoke(beanObject, (returnedValue.trim()));
									}
								}
								catch (SecurityException e) {
									e.printStackTrace();
									throw e;
								}
								catch (NoSuchMethodException e) {
									e.printStackTrace();
									if (!throwNoSuchMethodException) {
										noSuchMethodException = e;
									}
									throwNoSuchMethodException = true;
								}
								catch (IllegalArgumentException e) {
									e.printStackTrace();
									throw e;
								}
								catch (IllegalAccessException e) {
									e.printStackTrace();
									throw e;
								}
								catch (InvocationTargetException e) {
									e.printStackTrace();
									throw e;
								}
							}
						}
					}
				}
			}
		}

		if (throwNoSuchMethodException && noSuchMethodException != null) {
			throw noSuchMethodException;
		}
	}

	private static String[] getNullPropertyNames(Object source) {
		final BeanWrapper src = new BeanWrapperImpl(source);
		java.beans.PropertyDescriptor[] pds = src.getPropertyDescriptors();

		Set<String> emptyNames = new HashSet<String>();
		for (java.beans.PropertyDescriptor pd : pds) {
			Object srcValue = src.getPropertyValue(pd.getName());
			if (srcValue == null)
				emptyNames.add(pd.getName());
		}
		String[] result = new String[emptyNames.size()];
		return emptyNames.toArray(result);
	}

	// then use Spring BeanUtils to copy and ignore null
	private static void copyNotNullProperties(Object src, Object target, String nullExceptions[]) {

		String[] nullPropertiesNames = getNullPropertyNames(src);

		//for (String item : nullPropertiesNames)
		//	log.info("nullPropertiesNames: " + item);

		//for (String item : nullExceptions)
		//	log.info("nullExceptions: " + item);

		@SuppressWarnings("unchecked")
		List<String> exceptionProperties = (List<String>) CollectionUtils.subtract(new ArrayList<String>(Arrays.asList(nullPropertiesNames)), new ArrayList<String>(Arrays.asList(nullExceptions)));

		//log.info("exceptionProperties: " + exceptionProperties);

		BeanUtils.copyProperties(src, target, exceptionProperties.toArray(new String[exceptionProperties.size()]));
	}

	public static <T> T mergeNotNullProperties(T target, T source, String mergeNullExceptions[], Class<T> cT) throws InstantiationException, IllegalAccessException {
		T insert = null;

		//log.info("target: " + target);
		//log.info("source: " + source);

		insert = cT.newInstance();
		BeanUtils.copyProperties(target, insert);

		//log.info("source A: " + insert);

		copyNotNullProperties(source, insert, mergeNullExceptions);

		//log.info("source B: " + insert);

		return insert;
	}

		
		/*public static void main(String args[]){
			
			ContratoMaterialDTO n = new ContratoMaterialDTO();
			ContratoMaterialDTO n1 = new ContratoMaterialDTO();
			ContratoMaterialDTO n2 = new ContratoMaterialDTO();
			
			n1.setIdCntMaterial(1L);
			n2.setIdCntMaterial(2L);
			n1.setNumDocto("TEST");
			
			
			PedidoI37DTO p = new PedidoI37DTO();
			PedidoI37DTO p1 = new PedidoI37DTO();
			PedidoI37DTO p2 = new PedidoI37DTO();
			
	p1.setCodigoMaterial("SOURCE");
	p1.setOrdenCompra("ORDEN");
	p2.setCodigoMaterial("TARGET");


			try {
		        n = mergeNotNullProperties(n1,n2, new String []{}, ContratoMaterialDTO.class);
		        p = mergeNotNullProperties(p1,p2, new String []{}, PedidoI37DTO.class);

	        }
	        catch (InstantiationException | IllegalAccessException e) {
		        // TODO Auto-generated catch block
		        e.printStackTrace();
	        }
			
			System.out.println(n);
			System.out.println(p);

		}*/

}
