package com.mx.dla.dda.utilerias;

import java.util.regex.Pattern;

public class StringUtilerias {

	private static final Pattern DOUBLE_PATTERN   = Pattern.compile("[\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)"
	                                                      + "([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|"
	                                                      + "(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))" + "[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*");

	private static final Pattern CURRENCY_PATTERN = Pattern.compile("(?=.)^\\$?(([1-9][0-9]{0,2}(,[0-9]{3})*)|[0-9]+)?(\\.[0-9]{1,4})?$");

	private static final Pattern FLOAT_PATTERN = Pattern.compile("^([+-]?(\\d+\\.)?\\d+)$");

	
	public static boolean isCurrency(String s) {
		return CURRENCY_PATTERN.matcher(s).matches();
	}

	public static boolean isDouble(String s) {
		return DOUBLE_PATTERN.matcher(s).matches();
	}
	
	public static boolean isFloat(String s) {
		return FLOAT_PATTERN.matcher(s).matches();

	}

}
